/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tomlj;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import zz.org.antlr.v4.runtime.CharStream;
import zz.org.antlr.v4.runtime.CharStreams;
import zz.org.antlr.v4.runtime.CodePointCharStream;
import zz.org.tomlj.Parser;
import zz.org.tomlj.TomlParseResult;
import zz.org.tomlj.TomlVersion;

public final class Toml {
    private static final Pattern simpleKeyPattern = Pattern.compile("^[A-Za-z0-9_-]+$");

    private Toml() {
    }

    public static TomlParseResult parse(String input) {
        return Toml.parse(input, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(String input, TomlVersion version) {
        CodePointCharStream stream = CharStreams.fromString(input);
        return Parser.parse(stream, version.canonical);
    }

    public static TomlParseResult parse(Path file) throws IOException {
        return Toml.parse(file, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(Path file, TomlVersion version) throws IOException {
        CharStream stream = CharStreams.fromPath(file);
        return Parser.parse(stream, version.canonical);
    }

    public static TomlParseResult parse(InputStream is) throws IOException {
        return Toml.parse(is, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(InputStream is, TomlVersion version) throws IOException {
        CharStream stream = CharStreams.fromStream(is);
        return Parser.parse(stream, version.canonical);
    }

    public static TomlParseResult parse(Reader reader) throws IOException {
        return Toml.parse(reader, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(Reader reader, TomlVersion version) throws IOException {
        CodePointCharStream stream = CharStreams.fromReader(reader);
        return Parser.parse(stream, version.canonical);
    }

    public static TomlParseResult parse(ReadableByteChannel channel) throws IOException {
        return Toml.parse(channel, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(ReadableByteChannel channel, TomlVersion version) throws IOException {
        CharStream stream = CharStreams.fromChannel(channel);
        return Parser.parse(stream, version.canonical);
    }

    public static List<String> parseDottedKey(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return Parser.parseDottedKey(dottedKey);
    }

    public static String joinKeyPath(List<String> path) {
        Objects.requireNonNull(path);
        StringJoiner joiner = new StringJoiner(".");
        for (String key : path) {
            if (simpleKeyPattern.matcher(key).matches()) {
                joiner.add(key);
                continue;
            }
            joiner.add("\"" + Toml.tomlEscape(key) + '\"');
        }
        return joiner.toString();
    }

    public static String canonicalDottedKey(String dottedKey) {
        return Toml.joinKeyPath(Toml.parseDottedKey(dottedKey));
    }

    public static StringBuilder tomlEscape(String text) {
        StringBuilder out = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            int codepoint = text.codePointAt(i);
            if (Character.charCount(codepoint) > 1) {
                out.append("\\U").append(String.format("%08x", codepoint));
                ++i;
                continue;
            }
            char ch = Character.toChars(codepoint)[0];
            if (ch == '\'') {
                out.append("\\'");
                continue;
            }
            if (ch >= ' ' && ch < '\u007f') {
                out.append(ch);
                continue;
            }
            switch (ch) {
                case '\t': {
                    out.append("\\t");
                    continue block7;
                }
                case '\b': {
                    out.append("\\b");
                    continue block7;
                }
                case '\n': {
                    out.append("\\n");
                    continue block7;
                }
                case '\r': {
                    out.append("\\r");
                    continue block7;
                }
                case '\f': {
                    out.append("\\f");
                    continue block7;
                }
                default: {
                    out.append("\\u").append(String.format("%04x", codepoint));
                }
            }
        }
        return out;
    }
}

