/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz;

import java.io.InputStream;
import zz.org.tukaani.xz.FilterDecoder;
import zz.org.tukaani.xz.LZMA2Coder;
import zz.org.tukaani.xz.LZMA2InputStream;
import zz.org.tukaani.xz.UnsupportedOptionsException;

class LZMA2Decoder
extends LZMA2Coder
implements FilterDecoder {
    private int dictSize;

    LZMA2Decoder(byte[] byArray) throws UnsupportedOptionsException {
        if (byArray.length != 1 || (byArray[0] & 0xFF) > 37) {
            throw new UnsupportedOptionsException("Unsupported LZMA2 properties");
        }
        this.dictSize = 2 | byArray[0] & 1;
        this.dictSize <<= (byArray[0] >>> 1) + 11;
    }

    public int getMemoryUsage() {
        return LZMA2InputStream.getMemoryUsage(this.dictSize);
    }

    public InputStream getInputStream(InputStream inputStream) {
        return new LZMA2InputStream(inputStream, this.dictSize);
    }
}

