/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import java.util.Collections;
import java.util.List;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Service;
import org.cyclonedx.model.vulnerability.Vulnerability;

public class ObjectLocator {
    private final Bom bom;
    private final String bomRef;
    private Object object;
    private boolean isMetadataComponent;

    public ObjectLocator(Bom bom, String bomRef) {
        this.bom = bom;
        this.bomRef = bomRef;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean found() {
        return this.object != null;
    }

    public boolean isMetadataComponent() {
        return this.isMetadataComponent;
    }

    public boolean isComponent() {
        return this.object instanceof Component;
    }

    public boolean isService() {
        return this.object instanceof Service;
    }

    public boolean isVulnerability() {
        return this.object instanceof Vulnerability;
    }

    public ObjectLocator locate() {
        if (this.bom == null || this.bomRef == null) {
            return this;
        }
        if (this.bom.getMetadata() != null && this.bom.getMetadata().getComponent() != null) {
            Vulnerability v;
            Service s;
            Component c = ObjectLocator.findComponent(Collections.singletonList(this.bom.getMetadata().getComponent()), this.bomRef);
            if (c != null) {
                this.isMetadataComponent = true;
                this.object = c;
            }
            if ((c = ObjectLocator.findComponent(this.bom.getComponents(), this.bomRef)) != null) {
                this.object = c;
            }
            if ((s = ObjectLocator.findService(this.bom.getServices(), this.bomRef)) != null) {
                this.object = s;
            }
            if ((v = ObjectLocator.findVulnerability(this.bom.getVulnerabilities(), this.bomRef)) != null) {
                this.object = v;
            }
        }
        return this;
    }

    private static Component findComponent(List<Component> components, String bomRef) {
        if (components == null) {
            return null;
        }
        for (Component component : components) {
            Component child;
            if (bomRef.equals(component.getBomRef())) {
                return component;
            }
            if (component.getComponents() == null || (child = ObjectLocator.findComponent(component.getComponents(), bomRef)) == null) continue;
            return child;
        }
        return null;
    }

    private static Service findService(List<Service> services, String bomRef) {
        if (services == null) {
            return null;
        }
        for (Service service : services) {
            Service child;
            if (bomRef.equals(service.getBomRef())) {
                return service;
            }
            if (service.getServices() == null || (child = ObjectLocator.findService(service.getServices(), bomRef)) == null) continue;
            return child;
        }
        return null;
    }

    private static Vulnerability findVulnerability(List<Vulnerability> vulnerabilities, String bomRef) {
        if (vulnerabilities == null) {
            return null;
        }
        for (Vulnerability vulnerability : vulnerabilities) {
            if (!bomRef.equals(vulnerability.getBomRef())) continue;
            return vulnerability;
        }
        return null;
    }
}

