/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;

public class DebianDependency {
    private final String name;
    private final String version;
    private final String namespacePart;

    private DebianDependency(String name, String version, String namespacePart) {
        this.name = name;
        this.version = version;
        this.namespacePart = namespacePart;
    }

    public static DebianDependency fromString(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        String[] sections = line.split("\\s+");
        if (sections.length != 2) {
            return null;
        }
        String nameSection = sections[0].trim();
        if (nameSection.isEmpty()) {
            return null;
        }
        String versionSection = sections[1].trim();
        if (versionSection.isEmpty()) {
            return null;
        }
        for (SupportedNamespaces namespace : SupportedNamespaces.values()) {
            if (!versionSection.contains(namespace.id)) continue;
            int index = versionSection.contains("~") ? versionSection.lastIndexOf("~") : (versionSection.contains("+") ? versionSection.lastIndexOf("+") : (versionSection.contains("-") ? versionSection.lastIndexOf("-") : versionSection.lastIndexOf(namespace.id)));
            String versionPart = versionSection.substring(0, index);
            String namespacePart = versionSection.substring(index);
            return new DebianDependency(nameSection, versionPart, namespacePart);
        }
        return new DebianDependency(nameSection, versionSection, null);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNamespace() {
        if (this.namespacePart != null) {
            for (SupportedNamespaces namespace : SupportedNamespaces.values()) {
                if (!this.namespacePart.contains(namespace.id)) continue;
                return namespace.label;
            }
        }
        return SupportedNamespaces.DEBIAN.label;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof DebianDependency)) {
            return false;
        }
        DebianDependency otherDependency = (DebianDependency)otherObject;
        return Objects.equals(this.name, otherDependency.name) && Objects.equals(this.version, otherDependency.version) && Objects.equals(this.namespacePart, otherDependency.namespacePart);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.namespacePart);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("\t").append(this.version);
        if (this.namespacePart != null) {
            sb.append(this.namespacePart);
        }
        return sb.toString();
    }

    private static enum SupportedNamespaces {
        UBUNTU("ubuntu", "ubuntu"),
        DEBIAN("deb", "debian");

        private final String id;
        private final String label;

        private SupportedNamespaces(String id, String label) {
            this.id = id;
            this.label = label;
        }
    }
}

