/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.util.Assert;

public class Point
extends Geometry
implements Puntal {
    private static final long serialVersionUID = 4902022702746614570L;
    private CoordinateSequence coordinates;

    public Point(Coordinate coordinate, PrecisionModel precisionModel, int SRID) {
        super(new GeometryFactory(precisionModel, SRID));
        Coordinate[] coordinateArray;
        CoordinateSequenceFactory coordinateSequenceFactory = this.getFactory().getCoordinateSequenceFactory();
        if (coordinate != null) {
            Coordinate[] coordinateArray2 = new Coordinate[1];
            coordinateArray = coordinateArray2;
            coordinateArray2[0] = coordinate;
        } else {
            coordinateArray = new Coordinate[]{};
        }
        this.init(coordinateSequenceFactory.create(coordinateArray));
    }

    public Point(CoordinateSequence coordinates, GeometryFactory factory) {
        super(factory);
        this.init(coordinates);
    }

    private void init(CoordinateSequence coordinates) {
        if (coordinates == null) {
            coordinates = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        Assert.isTrue(coordinates.size() <= 1);
        this.coordinates = coordinates;
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray;
        if (this.isEmpty()) {
            coordinateArray = new Coordinate[]{};
        } else {
            Coordinate[] coordinateArray2 = new Coordinate[1];
            coordinateArray = coordinateArray2;
            coordinateArray2[0] = this.getCoordinate();
        }
        return coordinateArray;
    }

    public int getNumPoints() {
        return this.isEmpty() ? 0 : 1;
    }

    public boolean isEmpty() {
        return this.getCoordinate() == null;
    }

    public boolean isSimple() {
        return true;
    }

    public int getDimension() {
        return 0;
    }

    public int getBoundaryDimension() {
        return -1;
    }

    public double getX() {
        if (this.getCoordinate() == null) {
            throw new IllegalStateException("getX called on empty Point");
        }
        return this.getCoordinate().x;
    }

    public double getY() {
        if (this.getCoordinate() == null) {
            throw new IllegalStateException("getY called on empty Point");
        }
        return this.getCoordinate().y;
    }

    public Coordinate getCoordinate() {
        return this.coordinates.size() != 0 ? this.coordinates.getCoordinate(0) : null;
    }

    public String getGeometryType() {
        return "Point";
    }

    public Geometry getBoundary() {
        return this.getFactory().createGeometryCollection(null);
    }

    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        Envelope env = new Envelope();
        env.expandToInclude(this.coordinates.getX(0), this.coordinates.getY(0));
        return env;
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        return this.equal(((Point)other).getCoordinate(), this.getCoordinate(), tolerance);
    }

    public void apply(CoordinateFilter filter) {
        if (this.isEmpty()) {
            return;
        }
        filter.filter(this.getCoordinate());
    }

    public void apply(CoordinateSequenceFilter filter) {
        if (this.isEmpty()) {
            return;
        }
        filter.filter(this.coordinates, 0);
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
    }

    public Object clone() {
        Point p = (Point)super.clone();
        p.coordinates = (CoordinateSequence)this.coordinates.clone();
        return p;
    }

    public Geometry reverse() {
        return (Geometry)this.clone();
    }

    public void normalize() {
    }

    protected int compareToSameClass(Object other) {
        Point point = (Point)other;
        return this.getCoordinate().compareTo(point.getCoordinate());
    }

    protected int compareToSameClass(Object other, CoordinateSequenceComparator comp) {
        Point point = (Point)other;
        return comp.compare(this.coordinates, point.coordinates);
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.coordinates;
    }
}

