/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Level
extends Enum<Level> {
    public static final /* enum */ Level ALL = new Level(-1000);
    public static final /* enum */ Level TRACE = new Level(0);
    public static final /* enum */ Level DEBUG = new Level(10);
    public static final /* enum */ Level INFO = new Level(20);
    public static final /* enum */ Level WARN = new Level(30);
    public static final /* enum */ Level ERROR = new Level(40);
    public static final /* enum */ Level OFF = new Level(1000);
    public final int id;
    private static final /* synthetic */ Level[] $VALUES;

    public static Level[] values() {
        return (Level[])$VALUES.clone();
    }

    public static Level valueOf(String name) {
        return Enum.valueOf(Level.class, name);
    }

    private Level(int id) {
        this.id = id;
    }

    public boolean isEnabled(Logger logger) {
        assert (logger != null);
        switch (this) {
            case ALL: {
                return true;
            }
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        return false;
    }

    public void log(Logger logger, String msg) {
        assert (logger != null);
        switch (this) {
            case TRACE: {
                logger.trace(msg);
                break;
            }
            case DEBUG: {
                logger.debug(msg);
                break;
            }
            case INFO: {
                logger.info(msg);
                break;
            }
            case WARN: {
                logger.warn(msg);
                break;
            }
            case ERROR: {
                logger.error(msg);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void log(Logger logger, String format, Object arg) {
        assert (logger != null);
        switch (this) {
            case TRACE: {
                logger.trace(format, arg);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg);
                break;
            }
            case INFO: {
                logger.info(format, arg);
                break;
            }
            case WARN: {
                logger.warn(format, arg);
                break;
            }
            case ERROR: {
                logger.error(format, arg);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void log(Logger logger, String format, Object arg1, Object arg2) {
        assert (logger != null);
        switch (this) {
            case TRACE: {
                logger.trace(format, arg1, arg2);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg1, arg2);
                break;
            }
            case INFO: {
                logger.info(format, arg1, arg2);
                break;
            }
            case WARN: {
                logger.warn(format, arg1, arg2);
                break;
            }
            case ERROR: {
                logger.error(format, arg1, arg2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void log(Logger logger, String format, Object ... args) {
        assert (logger != null);
        switch (this) {
            case TRACE: {
                logger.trace(format, args);
                break;
            }
            case DEBUG: {
                logger.debug(format, args);
                break;
            }
            case INFO: {
                logger.info(format, args);
                break;
            }
            case WARN: {
                logger.warn(format, args);
                break;
            }
            case ERROR: {
                logger.error(format, args);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void log(Logger logger, String msg, Throwable cause) {
        assert (logger != null);
        switch (this) {
            case TRACE: {
                logger.trace(msg, cause);
                break;
            }
            case DEBUG: {
                logger.debug(msg, cause);
                break;
            }
            case INFO: {
                logger.info(msg, cause);
                break;
            }
            case WARN: {
                logger.warn(msg, cause);
                break;
            }
            case ERROR: {
                logger.error(msg, cause);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    static {
        $VALUES = new Level[]{ALL, TRACE, DEBUG, INFO, WARN, ERROR, OFF};
    }
}

