/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.cvss;

import javax.annotation.Nullable;

public enum Cvss2Severity {
    UNKNOWN("unknown"),
    LOW("Low"),
    MEDIUM("Medium"),
    HIGH("High");

    private final String label;

    private Cvss2Severity(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    public static Cvss2Severity of(@Nullable Float score) {
        if (score != null) {
            if (score.floatValue() >= 0.0f && score.floatValue() < 4.0f) {
                return LOW;
            }
            if (score.floatValue() >= 4.0f && score.floatValue() < 7.0f) {
                return MEDIUM;
            }
            if (score.floatValue() >= 7.0f && score.floatValue() <= 10.0f) {
                return HIGH;
            }
        }
        return UNKNOWN;
    }
}

