/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.Nullable;
import org.sonatype.ossindex.service.client.cache.CacheConfiguration;
import org.sonatype.ossindex.service.client.transport.AuthConfiguration;
import org.sonatype.ossindex.service.client.transport.ProxyConfiguration;

public class OssindexClientConfiguration {
    public static final URI DEFAULT_BASE_URL = URI.create("https://ossindex.sonatype.org/");
    public static final int DEFAULT_BATCH_SIZE = 128;
    @JsonProperty
    private URI baseUrl = DEFAULT_BASE_URL;
    @JsonProperty
    private int batchSize = 128;
    @Nullable
    @JsonProperty(value="auth")
    private AuthConfiguration authConfiguration;
    @Nullable
    @JsonProperty(value="proxy")
    private ProxyConfiguration proxyConfiguration;
    @Nullable
    @JsonProperty(value="cache")
    private CacheConfiguration cacheConfiguration;

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URI baseUrl) {
        this.baseUrl = (URI)Preconditions.checkNotNull((Object)baseUrl);
    }

    public void setBaseUrl(String baseUrl) {
        Preconditions.checkNotNull((Object)baseUrl);
        this.setBaseUrl(URI.create(baseUrl));
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Nullable
    public AuthConfiguration getAuthConfiguration() {
        return this.authConfiguration;
    }

    public void setAuthConfiguration(@Nullable AuthConfiguration authConfiguration) {
        this.authConfiguration = authConfiguration;
    }

    @Nullable
    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public void setProxyConfiguration(@Nullable ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    @Nullable
    public CacheConfiguration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public void setCacheConfiguration(@Nullable CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }
}

