/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.internal;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    public static final String RESOURCE = "version.properties";
    public static final String UNKNOWN = "unknown";
    private final Class owner;
    private Properties properties;

    public Version(Class owner) {
        this.owner = (Class)Preconditions.checkNotNull((Object)owner);
    }

    private Properties load() {
        Properties result = new Properties();
        URL resource = this.owner.getResource(RESOURCE);
        if (resource == null) {
            log.warn("Missing resource: {}", (Object)RESOURCE);
        } else {
            log.debug("Resource: {}", (Object)resource);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream input = resource.openStream();){
                    result.load(input);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.warn("Failed to load resource: {}", (Object)RESOURCE, (Object)e);
            }
            log.debug("Properties: {}", (Object)result);
        }
        return result;
    }

    private Properties properties() {
        if (this.properties == null) {
            this.properties = this.load();
        }
        return this.properties;
    }

    private String property(String name) {
        String value = this.properties().getProperty(name);
        if (value == null || value.contains("${")) {
            return UNKNOWN;
        }
        return value;
    }

    public String getVersion() {
        return this.property("version");
    }

    public String getTimestamp() {
        return this.property("timestamp");
    }

    public String getTag() {
        return this.property("tag");
    }

    public String toString() {
        return String.format("%s (%s; %s)", this.getVersion(), this.getTimestamp(), this.getTag());
    }
}

