/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.marshal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.sonatype.goodies.packageurl.jackson.PackageUrlModule;
import org.sonatype.ossindex.service.client.marshal.Marshaller;

public class JacksonMarshaller
implements Marshaller {
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new PackageUrlModule()).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    @Override
    public String marshal(Object value) throws IOException {
        Preconditions.checkNotNull((Object)value);
        return this.objectMapper.writeValueAsString(value);
    }

    @Override
    public void marshal(Object value, Writer writer) throws IOException {
        Preconditions.checkNotNull((Object)value);
        this.objectMapper.writeValue(writer, value);
        writer.flush();
    }

    @Override
    public <T> T unmarshal(String value, Class<T> type) throws IOException {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull(type);
        return (T)this.objectMapper.readValue(value, type);
    }

    @Override
    public <T> T unmarshal(String value, TypeToken<T> type) throws IOException {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull(type);
        return (T)this.objectMapper.readValue(value, this.objectMapper.constructType(type.getType()));
    }

    @Override
    public <T> T unmarshal(Reader reader, Class<T> type) throws IOException {
        Preconditions.checkNotNull((Object)reader);
        Preconditions.checkNotNull(type);
        return (T)this.objectMapper.readValue(reader, type);
    }

    @Override
    public <T> T unmarshal(Reader reader, TypeToken<T> type) throws IOException {
        Preconditions.checkNotNull((Object)reader);
        Preconditions.checkNotNull(type);
        return (T)this.objectMapper.readValue(reader, this.objectMapper.constructType(type.getType()));
    }
}

