/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLocker {
    private static final Logger log = LoggerFactory.getLogger(FileLocker.class);
    private static final String READ_MODE = "r";
    private static final String WRITE_MODE = "rws";

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T lock(Path path, boolean shared, FileFunction<T> function) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(function);
        String mode = shared ? READ_MODE : WRITE_MODE;
        log.trace("Locking: {}; mode: {}", (Object)path, (Object)mode);
        Throwable throwable = null;
        Object var5_6 = null;
        try (RandomAccessFile file = new RandomAccessFile(path.toFile(), mode);){
            T t;
            block15: {
                block14: {
                    FileLock lock = file.getChannel().lock(0L, Long.MAX_VALUE, shared);
                    try {
                        log.trace("Locked: {}", (Object)path);
                        t = function.apply(file);
                        if (!lock.isValid()) break block14;
                    }
                    catch (Throwable throwable2) {
                        if (lock.isValid()) {
                            lock.release();
                            log.trace("Unlocked: {}", (Object)path);
                        } else {
                            log.trace("Invalid: {}", (Object)path);
                        }
                        throw throwable2;
                    }
                    lock.release();
                    log.trace("Unlocked: {}", (Object)path);
                    break block15;
                }
                log.trace("Invalid: {}", (Object)path);
            }
            return t;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static <T> T readLock(Path path, FileFunction<T> function) throws IOException {
        return FileLocker.lock(path, true, function);
    }

    public static <T> T writeLock(Path path, FileFunction<T> function) throws IOException {
        return FileLocker.lock(path, false, function);
    }

    public static interface FileFunction<T> {
        public T apply(RandomAccessFile var1) throws IOException;
    }
}

