/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.core4j.Func;
import org.odata4j.core.ImmutableList;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmOnDeleteAction;

public class EdmAssociationEnd
extends EdmItem {
    private final String role;
    private final Func<EdmEntityType> type;
    private final EdmMultiplicity multiplicity;
    private final EdmOnDeleteAction onDeleteAction;

    private EdmAssociationEnd(String role, Func<EdmEntityType> type, EdmMultiplicity multiplicity, EdmOnDeleteAction onDeleteAction, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annots, ImmutableList<EdmAnnotation<?>> annotElements) {
        super(doc, annots, annotElements);
        this.role = role;
        this.type = type;
        this.multiplicity = multiplicity;
        this.onDeleteAction = onDeleteAction;
    }

    public String getRole() {
        return this.role;
    }

    public EdmEntityType getType() {
        return (EdmEntityType)this.type.apply();
    }

    public EdmMultiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public EdmOnDeleteAction getOnDeleteAction() {
        return this.onDeleteAction;
    }

    public String toString() {
        return String.format("EdmAssociationEnd[%s,%s,%s,%s]", new Object[]{this.role, this.type, this.multiplicity, this.onDeleteAction});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(EdmAssociationEnd associationEnd, EdmItem.BuilderContext context) {
        return context.newBuilder(associationEnd, new Builder());
    }

    public static class Builder
    extends EdmItem.Builder<EdmAssociationEnd, Builder> {
        private String role;
        private EdmEntityType.Builder type;
        private String typeName;
        private EdmMultiplicity multiplicity;
        private EdmOnDeleteAction onDeleteAction;

        @Override
        Builder newBuilder(EdmAssociationEnd associationEnd, EdmItem.BuilderContext context) {
            this.role = associationEnd.role;
            this.type = EdmEntityType.newBuilder(associationEnd.getType(), context);
            this.multiplicity = associationEnd.multiplicity;
            this.onDeleteAction = associationEnd.onDeleteAction;
            return this;
        }

        public EdmAssociationEnd build() {
            return new EdmAssociationEnd(this.role, this.type == null ? null : this.type.builtFunc(), this.multiplicity, this.onDeleteAction, this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()), ImmutableList.copyOf(this.getAnnotationElements()));
        }

        public Builder setRole(String role) {
            this.role = role;
            return this;
        }

        public Builder setType(EdmEntityType.Builder type) {
            this.type = type;
            return this;
        }

        public Builder setTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder setMultiplicity(EdmMultiplicity multiplicity) {
            this.multiplicity = multiplicity;
            return this;
        }

        public Builder setOnDeleteAction(EdmOnDeleteAction onDeleteAction) {
            this.onDeleteAction = onDeleteAction;
            return this;
        }

        public EdmEntityType.Builder getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getRole() {
            return this.role;
        }
    }
}

