/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.anon;

import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.util.HashUtils;
import javax.inject.Named;

@Named
public class Anonymizer {
    private static final String DIGESTER = "SHA-1";

    public String hash(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return HashUtils.hash(value, DIGESTER);
    }

    public String anonymizeArtifactId(String id) {
        if (id == null) {
            return id;
        }
        StringBuilder buffer = new StringBuilder(256);
        String[] parts = ArtifactId.split((String)id);
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                buffer.append(':');
            }
            buffer.append(this.hash(parts[i]));
        }
        return buffer.toString();
    }
}

