/*
 * Decompiled with CFR 0.152.
 */
package com.neuvector;

import com.google.gson.Gson;
import com.neuvector.DockerRunCommandBuilder;
import com.neuvector.model.Image;
import com.neuvector.model.NVScanner;
import com.neuvector.model.Registry;
import com.neuvector.model.ScanRepoReportData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.Random;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class Scanner {
    private static final String SOCKET_MAPPING = "/var/run/docker.sock:/var/run/docker.sock";
    private static final String CONTAINER_PATH = "/var/neuvector";
    private static final String SCAN_REPORT = "scan_result.json";

    public static ScanRepoReportData scanRegistry(Registry registry, NVScanner nvScanner, String license, Boolean scanLayers) {
        ScanRepoReportData reportData;
        String errorMessage = "";
        errorMessage = registry == null || nvScanner == null ? "The Registry and nvScanner can't be null." : Scanner.pullDockerImage(nvScanner);
        if (errorMessage.length() > 0) {
            reportData = new ScanRepoReportData();
            reportData.setError_message(errorMessage);
        } else {
            DockerRunCommandBuilder builder = new DockerRunCommandBuilder();
            builder.withUserAndGroup(Scanner.getDockerUserGroupCmdArg(Scanner.getScanReportPath(nvScanner.getNvMountPath()))).withName(Scanner.generateScannerName()).withVolume(SOCKET_MAPPING).withVolume(Scanner.getMountPath(nvScanner)).withEnvironment("SCANNER_REPOSITORY=" + registry.getRepository()).withEnvironment("SCANNER_TAG=" + registry.getRepositoryTag()).withEnvironment("SCANNER_LICENSE=" + license).withEnvironment("SCANNER_REGISTRY=" + registry.getRegistryURL());
            if (scanLayers.booleanValue()) {
                builder.withEnvironment("SCANNER_SCAN_LAYERS=true");
            }
            if (registry.getLoginUser() != null || registry.getLoginPassword() != null) {
                builder.withEnvironment("SCANNER_REGISTRY_USERNAME=" + registry.getLoginUser()).withEnvironment("SCANNER_REGISTRY_PASSWORD=" + registry.getLoginPassword());
            }
            String[] cmdArgs = builder.buildForImage(Scanner.getNVImagePath(nvScanner.getNvScannerImage(), nvScanner.getNvRegistryURL()));
            String[] credentials = new String[]{registry.getLoginPassword(), license};
            reportData = Scanner.runScan(cmdArgs, nvScanner, credentials);
        }
        return reportData;
    }

    public static ScanRepoReportData scanRegistry(Registry registry, NVScanner nvScanner, String license) {
        return Scanner.scanRegistry(registry, nvScanner, license, false);
    }

    public static ScanRepoReportData scanLocalImage(Image image, NVScanner nvScanner, String license, Boolean scanLayers) {
        ScanRepoReportData reportData;
        String errorMessage = "";
        errorMessage = image == null || nvScanner == null ? "The image and nvScanner can't be null." : Scanner.pullDockerImage(nvScanner);
        if (errorMessage.length() > 0) {
            reportData = new ScanRepoReportData();
            reportData.setError_message(errorMessage);
        } else {
            String[] credentials = new String[]{license};
            DockerRunCommandBuilder builder = new DockerRunCommandBuilder();
            builder.withUserAndGroup(Scanner.getDockerUserGroupCmdArg(Scanner.getScanReportPath(nvScanner.getNvMountPath()))).withName(Scanner.generateScannerName()).withVolume(SOCKET_MAPPING).withVolume(Scanner.getMountPath(nvScanner)).withEnvironment("SCANNER_REPOSITORY=" + image.getImageName()).withEnvironment("SCANNER_TAG=" + image.getImageTag()).withEnvironment("SCANNER_LICENSE=" + license);
            if (scanLayers.booleanValue()) {
                builder.withEnvironment("SCANNER_SCAN_LAYERS=true");
            }
            String[] cmdArgs = builder.buildForImage(Scanner.getNVImagePath(nvScanner.getNvScannerImage(), nvScanner.getNvRegistryURL()));
            reportData = Scanner.runScan(cmdArgs, nvScanner, credentials);
        }
        return reportData;
    }

    public static ScanRepoReportData scanLocalImage(Image image, NVScanner nvScanner, String license) {
        return Scanner.scanLocalImage(image, nvScanner, license, false);
    }

    private static String pullDockerImage(NVScanner nvScanner) {
        String nvRegistryURL = nvScanner.getNvRegistryURL();
        String nvRegistryUser = nvScanner.getNvRegistryUser();
        String nvRegistryPassword = nvScanner.getNvRegistryPassword();
        String nvScannerImage = nvScanner.getNvScannerImage();
        Logger log = nvScanner.getLog();
        if (nvRegistryURL == null) {
            nvRegistryURL = "";
        }
        if (nvRegistryUser == null) {
            nvRegistryUser = "";
        }
        if (nvRegistryPassword == null) {
            nvRegistryPassword = "";
        }
        String errorMessage = "";
        if (nvRegistryURL.isEmpty() && nvRegistryUser.isEmpty() && nvRegistryPassword.isEmpty()) {
            return errorMessage;
        }
        if (!nvRegistryUser.equals("") && !nvRegistryPassword.equals("")) {
            String[] cmdArgsDockerLogin = new String[]{"docker", "login", "-u", nvRegistryUser, "-p", nvRegistryPassword, nvRegistryURL};
            errorMessage = Scanner.runCMD(cmdArgsDockerLogin, log);
            if (errorMessage.length() == 0) {
                String[] cmdArgsDockerPull = new String[]{"docker", "pull", Scanner.getNVImagePath(nvScannerImage, nvRegistryURL)};
                errorMessage = Scanner.runCMD(cmdArgsDockerPull, log);
                String[] cmdArgsDockerLogout = new String[]{"docker", "logout"};
                errorMessage = Scanner.runCMD(cmdArgsDockerLogout, log);
            }
        } else {
            String[] cmdArgsDockPull = new String[]{"docker", "pull", Scanner.getNVImagePath(nvScannerImage, nvRegistryURL)};
            errorMessage = Scanner.runCMD(cmdArgsDockPull, log);
        }
        if (!errorMessage.isEmpty() && !nvRegistryPassword.isEmpty()) {
            errorMessage = Scanner.maskCredential(errorMessage, nvRegistryPassword);
        }
        return errorMessage;
    }

    private static String getNVImagePath(String nvScannerImage, String nvRegistryURL) {
        String nvImagePath = "";
        if (nvRegistryURL.isEmpty()) {
            nvImagePath = nvScannerImage;
        } else {
            nvImagePath = nvRegistryURL.contains("//") ? nvRegistryURL.split("//")[1] : nvRegistryURL;
            nvImagePath = nvRegistryURL.endsWith("/") ? nvImagePath + nvScannerImage : nvImagePath + "/" + nvScannerImage;
        }
        return nvImagePath;
    }

    private static ScanRepoReportData parseScanReport(String scanReportPath) {
        ScanRepoReportData scanReportData;
        StringBuilder contentBuilder = new StringBuilder();
        String errorMessage = null;
        try (Stream<String> stream = Files.lines(Paths.get(scanReportPath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException ex) {
            errorMessage = ex.getMessage();
        }
        if (errorMessage != null) {
            scanReportData = new ScanRepoReportData();
            scanReportData.setError_message(errorMessage);
        } else {
            scanReportData = (ScanRepoReportData)new Gson().fromJson(contentBuilder.toString(), ScanRepoReportData.class);
        }
        return scanReportData;
    }

    private static String runCMD(String[] cmdArgs, Logger log) {
        String errorMessage = "";
        try {
            Process process = Runtime.getRuntime().exec(cmdArgs);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String s = null;
            StringBuilder sb = new StringBuilder(String.join((CharSequence)" ", cmdArgs));
            while ((s = stdInput.readLine()) != null) {
                if (log != null) {
                    log.info(s);
                }
                sb.append(s);
            }
            while ((s = stdError.readLine()) != null) {
                if (log != null) {
                    log.error(s);
                }
                sb.append(s);
            }
            if (process.waitFor() != 0) {
                errorMessage = sb.toString();
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (InterruptedException ex) {
            errorMessage = ex.getMessage();
        }
        return errorMessage;
    }

    private static ScanRepoReportData runScan(String[] cmdArgs, NVScanner nvScanner, String[] credentials) {
        String errorMessage = Scanner.runCMD(cmdArgs, nvScanner.getLog());
        ScanRepoReportData reportData = null;
        if (errorMessage.length() > 0) {
            for (String credential : credentials) {
                if (credential.isEmpty()) continue;
                errorMessage = Scanner.maskCredential(errorMessage, credential);
            }
            reportData = new ScanRepoReportData();
            reportData.setError_message(errorMessage);
        } else {
            reportData = Scanner.parseScanReport(Scanner.getScanReportPath(nvScanner.getNvMountPath()));
        }
        return reportData;
    }

    private static String getMountPath(NVScanner nvScanner) {
        String mountPath = ":/var/neuvector";
        String nvPath = nvScanner.getNvMountPath();
        if (nvPath != null && nvPath.length() > 0) {
            if (nvPath.charAt(nvPath.length() - 1) == '/') {
                nvPath = nvPath.substring(0, nvPath.length() - 1);
            }
            mountPath = nvPath + mountPath;
        } else {
            mountPath = CONTAINER_PATH + mountPath;
        }
        return mountPath;
    }

    private static String getScanReportPath(String path) {
        String scanReportPath = "";
        scanReportPath = path == null || path.length() == 0 ? "/var/neuvector/scan_result.json" : Scanner.removeLastSlash(path) + "/" + SCAN_REPORT;
        return scanReportPath;
    }

    private static String removeLastSlash(String str) {
        if (str != null && str.length() > 0 && str.charAt(str.length() - 1) == '/') {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static String generateScannerName() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 6) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    private static String maskCredential(String message, String credential) {
        return message.replace(credential, "******");
    }

    static String getDockerUserGroupCmdArg(String scanReportPath) {
        Boolean ownedByRoot = Scanner.ownedByRoot(scanReportPath);
        if (ownedByRoot != null && ownedByRoot.booleanValue()) {
            return null;
        }
        String cmdUserGroupArg = null;
        String UID = Scanner.executeCommand("id -u");
        if (UID != null && !UID.isEmpty()) {
            if ("0".equals(UID)) {
                return null;
            }
            String GID = Scanner.executeCommand("stat -c '%g' /var/run/docker.sock");
            if (GID != null && !GID.isEmpty()) {
                cmdUserGroupArg = UID + ":" + GID.replace("'", "");
            }
        }
        return cmdUserGroupArg;
    }

    private static Boolean ownedByRoot(String scanReportPath) {
        File scanResultFileJson = new File(scanReportPath);
        try {
            return Scanner.scanResultsFileExist(scanReportPath) && "root".equals(Scanner.getUserPrincipal(scanReportPath, scanResultFileJson).getName());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String executeCommand(String command) {
        StringBuilder output = new StringBuilder();
        try {
            Process proc = Runtime.getRuntime().exec(command);
            Scanner.getExecValueFromBuffer(output, proc);
        }
        catch (Exception e) {
            return null;
        }
        return output.toString();
    }

    private static void getExecValueFromBuffer(StringBuilder output, Process proc) throws IOException, InterruptedException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
            proc.waitFor();
        }
    }

    private static boolean scanResultsFileExist(String scanResultFilePath) {
        File scanResultFile = new File(scanResultFilePath);
        return scanResultFile.exists();
    }

    private static UserPrincipal getUserPrincipal(String mountPath, File file) throws IOException {
        UserPrincipal user = null;
        if (file.exists()) {
            Path path = Paths.get(mountPath, new String[0]);
            FileOwnerAttributeView fileOwner = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
            user = fileOwner.getOwner();
        }
        return user;
    }

    public static String deleteDockerImagesByLabelKey(String label) {
        String errorMessage = "";
        String[] cmdArgsDockerDelete = new String[]{"docker", "image", "prune", "--force", "--filter=label=".concat(label)};
        errorMessage = Scanner.runCMD(cmdArgsDockerDelete, null);
        return errorMessage;
    }
}

