/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.GeometricShapeFactory;

public class SineStarFactory
extends GeometricShapeFactory {
    protected int numArms = 8;
    protected double armLengthRatio = 0.5;

    public SineStarFactory() {
    }

    public SineStarFactory(GeometryFactory geomFact) {
        super(geomFact);
    }

    public void setNumArms(int numArms) {
        this.numArms = numArms;
    }

    public void setArmLengthRatio(double armLengthRatio) {
        this.armLengthRatio = armLengthRatio;
    }

    public Geometry createSineStar() {
        Envelope env = this.dim.getEnvelope();
        double radius = env.getWidth() / 2.0;
        double armRatio = this.armLengthRatio;
        if (armRatio < 0.0) {
            armRatio = 0.0;
        }
        if (armRatio > 1.0) {
            armRatio = 1.0;
        }
        double armMaxLen = armRatio * radius;
        double insideRadius = (1.0 - armRatio) * radius;
        double centreX = env.getMinX() + radius;
        double centreY = env.getMinY() + radius;
        Coordinate[] pts = new Coordinate[this.nPts + 1];
        int iPt = 0;
        for (int i = 0; i < this.nPts; ++i) {
            double ptArcFrac = (double)i / (double)this.nPts * (double)this.numArms;
            double armAngFrac = ptArcFrac - Math.floor(ptArcFrac);
            double armAng = Math.PI * 2 * armAngFrac;
            double armLenFrac = (Math.cos(armAng) + 1.0) / 2.0;
            double curveRadius = insideRadius + armMaxLen * armLenFrac;
            double ang = (double)i * (Math.PI * 2 / (double)this.nPts);
            double x = curveRadius * Math.cos(ang) + centreX;
            double y = curveRadius * Math.sin(ang) + centreY;
            pts[iPt++] = this.coord(x, y);
        }
        pts[iPt] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return poly;
    }
}

