/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Metered;
import com.palominolabs.metrics.guice.DeclaredMethodsTypeListener;
import com.palominolabs.metrics.guice.MeteredInterceptor;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.annotation.AnnotationResolver;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;

public class MeteredListener
extends DeclaredMethodsTypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public MeteredListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    @Override
    @Nullable
    protected MethodInterceptor getInterceptor(Method method) {
        Metered annotation = this.annotationResolver.findAnnotation(Metered.class, method);
        if (annotation != null) {
            Meter meter = this.metricRegistry.meter(this.metricNamer.getNameForMetered(method, annotation));
            return new MeteredInterceptor(meter);
        }
        return null;
    }
}

