/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model;

import java.io.Serializable;

public class ScanReceipt
implements Serializable {
    private static final long serialVersionUID = 3364592229802071709L;
    private String scanId;
    private Long timeToReport;
    private String reportUrl;
    private String pdfUrl;
    private String dataUrl;
    private Integer reportTimeoutInSeconds;

    public String getScanId() {
        return this.scanId;
    }

    public void setScanId(String scanId) {
        this.scanId = scanId;
    }

    public Long getTimeToReport() {
        return this.timeToReport;
    }

    public void setTimeToReport(Long timeToReport) {
        this.timeToReport = timeToReport;
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public String resolveReportUrl(String serverUrl) {
        return ScanReceipt.resolveUrl(serverUrl, this.getReportUrl());
    }

    public String getPdfUrl() {
        return this.pdfUrl;
    }

    public void setPdfUrl(String pdfUrl) {
        this.pdfUrl = pdfUrl;
    }

    public String resolvePdfUrl(String serverUrl) {
        return ScanReceipt.resolveUrl(serverUrl, this.getPdfUrl());
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public String resolveDataUrl(String serverUrl) {
        return ScanReceipt.resolveUrl(serverUrl, this.getDataUrl());
    }

    private static String resolveUrl(String serverUrl, String resourceUrl) {
        if (serverUrl == null || serverUrl.isEmpty()) {
            throw new IllegalArgumentException("server base URL missing");
        }
        if (resourceUrl == null) {
            return resourceUrl;
        }
        StringBuilder url = new StringBuilder(256);
        url.append(serverUrl);
        if (!serverUrl.endsWith("/")) {
            url.append('/');
        }
        url.append(resourceUrl.startsWith("/") ? resourceUrl.substring(1) : resourceUrl);
        return url.toString();
    }

    public void waitForReport() throws InterruptedException {
        if (this.getTimeToReport() != null) {
            Thread.sleep(this.getTimeToReport() * 1000L);
        }
    }

    public Integer getReportTimeoutInSeconds() {
        return this.reportTimeoutInSeconds;
    }

    public void setReportTimeoutInSeconds(Integer reportTimeoutInSeconds) {
        this.reportTimeoutInSeconds = reportTimeoutInSeconds;
    }
}

