/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.client;

import com.sonatype.insight.brain.client.AbstractRequestClient;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.Result;
import com.sonatype.insight.client.utils.UrlUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class ReportClient
extends AbstractRequestClient {
    private final String serverUrl;
    private final String appId;
    private final String scanId;

    public ReportClient(HttpClientUtils.Configuration config, String appId, String scanId) {
        super(config);
        if (scanId == null || scanId.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot create a ReportClient without a scanId");
        }
        this.serverUrl = config.getServerUrl();
        this.appId = UrlUtils.encodeUrlComponent(appId);
        this.scanId = UrlUtils.encodeUrlComponent(scanId);
    }

    public String linkToReport() {
        return UrlUtils.appendUrlPaths(this.serverUrl, "ui/links/application", this.appId, "report", this.scanId);
    }

    public void downloadBundle(File bundleFile) throws IOException {
        Object result = this.path("rest/report", this.appId, this.scanId, "downloadBundle").get();
        this.verifyStatusCode((Result)result);
        byte[] data = ((Result)result).data();
        try (FileOutputStream fos = new FileOutputStream(bundleFile);){
            fos.write(data);
        }
    }
}

