/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import java.io.IOException;
import java.net.ProtocolException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

class HttpRequestExecutor
extends org.apache.http.protocol.HttpRequestExecutor {
    private String userAgent;

    public HttpRequestExecutor(String userAgent) {
        this.userAgent = userAgent;
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("Client connection may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        try {
            return new HttpExchange(request, conn, context).perform();
        }
        catch (IOException | RuntimeException | HttpException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
    }

    public void preProcess(HttpRequest request, HttpProcessor processor, HttpContext ctx) throws HttpException, IOException {
        super.preProcess(request, processor, ctx);
        if (!request.containsHeader("User-Agent") && this.userAgent != null) {
            request.addHeader("User-Agent", this.userAgent);
        }
    }

    private static void closeConnection(HttpClientConnection conn) {
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class HttpExchange {
        private final HttpRequest request;
        private final HttpClientConnection conn;
        private final HttpContext context;
        private volatile Throwable error;
        private Thread entitySender;

        public HttpExchange(HttpRequest request, HttpClientConnection conn, HttpContext context) {
            this.request = request;
            this.conn = conn;
            this.context = context;
        }

        public HttpResponse perform() throws IOException, HttpException {
            HttpResponse response = this.doSendRequest();
            if (response == null) {
                try {
                    response = HttpRequestExecutor.this.doReceiveResponse(this.request, this.conn, this.context);
                }
                catch (Exception e) {
                    this.handleUploadError();
                    throw e;
                }
                try {
                    if (this.entitySender != null) {
                        this.entitySender.join();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted", e);
                }
                if (response.getStatusLine().getStatusCode() < 300) {
                    this.handleUploadError();
                }
            }
            return response;
        }

        private void handleUploadError() throws IOException, HttpException {
            if (this.error != null) {
                if (this.error instanceof RuntimeException) {
                    throw (RuntimeException)this.error;
                }
                if (this.error instanceof Error) {
                    throw (Error)this.error;
                }
                if (this.error instanceof HttpException) {
                    throw (HttpException)this.error;
                }
                if (this.error instanceof IOException) {
                    throw (IOException)this.error;
                }
                throw new IllegalStateException(this.error);
            }
        }

        private HttpResponse doSendRequest() throws IOException, HttpException {
            HttpResponse response = null;
            this.context.setAttribute("http.connection", (Object)this.conn);
            this.context.setAttribute("http.request_sent", (Object)Boolean.FALSE);
            this.conn.sendRequestHeader(this.request);
            this.conn.flush();
            if (this.request instanceof HttpEntityEnclosingRequest) {
                boolean sendentity = true;
                ProtocolVersion ver = this.request.getRequestLine().getProtocolVersion();
                if (((HttpEntityEnclosingRequest)this.request).expectContinue() && !ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0) && this.conn.isResponseAvailable(3000)) {
                    int status;
                    response = this.conn.receiveResponseHeader();
                    if (HttpRequestExecutor.this.canResponseHaveBody(this.request, response)) {
                        this.conn.receiveResponseEntity(response);
                    }
                    if ((status = response.getStatusLine().getStatusCode()) < 200) {
                        if (status != 100) {
                            throw new ProtocolException("Unexpected response: " + response.getStatusLine());
                        }
                        response = null;
                    } else {
                        sendentity = false;
                    }
                }
                if (sendentity) {
                    this.sendRequestEntity((HttpEntityEnclosingRequest)this.request);
                }
            }
            return response;
        }

        private void sendRequestEntity(final HttpEntityEnclosingRequest req) throws IOException {
            this.entitySender = new Thread(this.getClass().getSimpleName() + "-" + System.currentTimeMillis()){

                @Override
                public void run() {
                    try {
                        HttpExchange.this.conn.sendRequestEntity(req);
                        HttpExchange.this.conn.flush();
                        HttpExchange.this.context.setAttribute("http.request_sent", (Object)Boolean.TRUE);
                    }
                    catch (Throwable t) {
                        HttpExchange.this.error = t;
                    }
                }
            };
            this.entitySender.start();
            while (this.entitySender.isAlive() && !this.conn.isResponseAvailable(5000)) {
            }
        }
    }
}

