/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class ProxyExcludeHostsRoutePlanner
extends DefaultProxyRoutePlanner {
    private Pattern excludeHosts;

    public ProxyExcludeHostsRoutePlanner(HttpHost proxy, Collection<String> proxyExcludeHosts) {
        super(proxy);
        Args.notNull(proxyExcludeHosts, (String)"proxyExcludeHosts");
        this.excludeHosts = this.generateRegex(proxyExcludeHosts);
    }

    private Pattern generateRegex(Collection<String> proxyExcludeHosts) {
        ArrayList<String> regexList = this.wildcardToRegex(proxyExcludeHosts);
        String regex = this.joinIntoSingleRegex(regexList);
        return Pattern.compile(regex, 2);
    }

    private String joinIntoSingleRegex(ArrayList<String> regexes) {
        return Arrays.toString(regexes.toArray()).replace(", ", "|").replaceAll("[\\[\\]]", "");
    }

    private ArrayList<String> wildcardToRegex(Collection<String> proxyExcludeHosts) {
        ArrayList<String> regexes = new ArrayList<String>(proxyExcludeHosts.size());
        for (String wildcardHost : proxyExcludeHosts) {
            regexes.add(("\\Q" + wildcardHost + "\\E").replace("*", "\\E.*\\Q"));
        }
        return regexes;
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return this.excludeHosts.matcher(target.getHostName()).matches() ? null : super.determineProxy(target, request, context);
    }
}

