/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class Result {
    protected final HttpResponse response;

    protected Result(HttpResponse response) {
        this.response = response;
    }

    public int status() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String reason() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public String header(String name) {
        Header header = this.response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    public String text() throws IOException {
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
    }

    public byte[] data() throws IOException {
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            return null;
        }
        return EntityUtils.toByteArray((HttpEntity)entity);
    }

    public String message() {
        String contentType = this.header("Content-Type");
        if (contentType != null && contentType.contains(ContentType.TEXT_PLAIN.getMimeType())) {
            try {
                String text = this.text();
                if (text != null && !text.isEmpty()) {
                    return text;
                }
            }
            catch (IOException iOException) {}
        } else {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
        return this.reason();
    }
}

