/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.scan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class RepositoryItem {
    public abstract String getPath();

    public abstract Coords getCoordinates();

    public abstract InputStream newInputStream() throws IOException;

    public File getFile() {
        return null;
    }

    public String getSha1() {
        return null;
    }

    public String toString() {
        return this.getPath();
    }

    public static class MavenCoords
    implements Coords {
        private final String id;
        private final String moduleId;

        public MavenCoords(String groupId, String artifactId, String version, String classifier, String extension) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(groupId);
            buffer.append(':').append(artifactId);
            int len = buffer.length();
            buffer.append(':').append(extension);
            if (classifier != null && !classifier.isEmpty()) {
                buffer.append(':').append(classifier);
            }
            buffer.append(':').append(version);
            this.id = buffer.toString();
            buffer.setLength(len);
            buffer.append(':').append(version);
            this.moduleId = buffer.toString();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getModuleId() {
            return this.moduleId;
        }

        public String toString() {
            return this.getId();
        }
    }

    public static interface Coords {
        public String getId();

        public String getModuleId();
    }
}

