/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.scan;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.insight.rm.scan.RepositoryItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ScanConfiguration {
    private File workDir = ScanConfiguration.getDefaultWorkDir();
    private Properties scanOptions = new Properties();
    private String repositoryId;
    private String repositoryName;
    private String repositoryFormat;
    private ProprietaryConfig proprietaryConfig;
    private final List<RepositoryItem> componentItems = new ArrayList<RepositoryItem>(128);
    private final List<RepositoryItem> scanItems = new ArrayList<RepositoryItem>();

    private static File getDefaultWorkDir() {
        return new File(System.getProperty("java.io.tmpdir", "")).getAbsoluteFile();
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public ScanConfiguration setWorkDir(File workDir) {
        this.workDir = workDir != null ? workDir : ScanConfiguration.getDefaultWorkDir();
        return this;
    }

    public Properties getScanOptions() {
        return this.scanOptions;
    }

    public ScanConfiguration setScanOptions(Properties scanOptions) {
        this.scanOptions.clear();
        if (scanOptions != null) {
            this.scanOptions.putAll((Map<?, ?>)scanOptions);
        }
        return this;
    }

    public ScanConfiguration setScanOption(String key, String value) {
        if (value == null) {
            this.scanOptions.remove(key);
        } else {
            this.scanOptions.setProperty(key, value);
        }
        return this;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryFormat() {
        return this.repositoryFormat;
    }

    public ScanConfiguration setRepository(String id, String format, String name) {
        this.repositoryId = id;
        this.repositoryFormat = format;
        this.repositoryName = name;
        return this;
    }

    public ScanConfiguration setProprietaryConfig(ProprietaryConfig proprietaryConfig) {
        this.proprietaryConfig = proprietaryConfig;
        return this;
    }

    public ProprietaryConfig getProprietaryConfig() {
        return this.proprietaryConfig;
    }

    public void addItem(RepositoryItem item) {
        if (item != null) {
            if (this.isScanItem(item)) {
                this.scanItems.add(item);
            } else if (this.isComponentItem(item)) {
                this.componentItems.add(item);
            }
        }
    }

    private boolean isScanItem(RepositoryItem item) {
        String path = item.getPath();
        return path.endsWith("-sonatype-clm-scan.xml.gz") || path.endsWith("-nexus-iq-scan.xml.gz");
    }

    private boolean isComponentItem(RepositoryItem item) {
        String path = item.getPath();
        if (path.endsWith(".pom") || path.endsWith(".asc") || path.endsWith(".sha1") || path.endsWith(".md5")) {
            return false;
        }
        return !path.endsWith("-sources.jar") && !path.endsWith("-javadoc.jar") && !path.endsWith("-tests.jar");
    }

    List<RepositoryItem> getComponentItems() {
        return this.componentItems;
    }

    List<RepositoryItem> getScanItems() {
        return this.scanItems;
    }
}

