/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.scan;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.insight.brain.common.io.FileCleaner;
import com.sonatype.insight.rm.scan.Bindings;
import com.sonatype.insight.rm.scan.RepositoryItem;
import com.sonatype.insight.rm.scan.ScanConfiguration;
import com.sonatype.insight.scan.archive.Selector;
import com.sonatype.insight.scan.client.ClientScanRequest;
import com.sonatype.insight.scan.config.ScanPropertiesLoader;
import com.sonatype.insight.scan.file.Config;
import com.sonatype.insight.scan.file.FileScanRequest;
import com.sonatype.insight.scan.file.FileScanner;
import com.sonatype.insight.scan.file.ScanSession;
import com.sonatype.insight.scan.hash.SHA1;
import com.sonatype.insight.scan.model.Repository;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.util.HashUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.apache.commons.io.IOUtils;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.codehaus.plexus.util.ReaderFactory;
import zz.org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import zz.org.codehaus.plexus.util.xml.XmlStreamReader;
import zz.org.codehaus.plexus.util.xml.pull.MXParser;
import zz.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ScanFactory {
    private static final Logger log = LoggerFactory.getLogger(ScanFactory.class);
    private static final String CONFIGURATION_RESOURCE = ScanFactory.class.getName().replace('.', '/').replace(ScanFactory.class.getSimpleName(), "configuration.properties");

    public File forConfiguration(ScanConfiguration config) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException("scan configuration missing");
        }
        File scanFile = Files.createTempFile(config.getWorkDir().toPath(), "sonatype-clm-scan-", ".xml.gz", new FileAttribute[0]).toFile();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(scanFile), 32768)), "UTF-8");){
            this.scan(config, writer);
        }
        catch (IOException | RuntimeException e) {
            try {
                new FileCleaner().delete(scanFile);
            }
            catch (FileCleaner.FileDeletionException fde) {
                log.error("Unable to delete scanFile: {}", (Object)scanFile, (Object)fde);
            }
            throw e;
        }
        return scanFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(ScanConfiguration config, Writer writer) throws IOException {
        Scan scan = new Scan();
        scan.setConfiguration(this.getConfiguration(config));
        ScanSummary summary = scan.getSummary();
        summary.setStartTime();
        Bindings.clientScanner().scan(new ClientScanRequest(scan));
        HashSet<String> moduleIds = new HashSet<String>();
        HashSet<SHA1> componentHashes = new HashSet<SHA1>();
        HashSet<SHA1> scannedHashes = new HashSet<SHA1>();
        List<RepositoryItem> componentItems = config.getComponentItems();
        for (int i = componentItems.size() - 1; i >= 0; --i) {
            RepositoryItem item = componentItems.get(i);
            moduleIds.add(item.getCoordinates().getModuleId());
            String sha1 = item.getSha1();
            if (sha1 == null || sha1.isEmpty()) {
                try (InputStream is = item.newInputStream();){
                    sha1 = HashUtils.hash((InputStream)is, (String)"SHA-1");
                }
                componentItems.set(i, new HashedRepositoryItem(item, sha1));
            }
            componentHashes.add(this.normalizeSha1(sha1));
        }
        ScanWriter scanWriter = Bindings.scanWriterFactory().newWriter(writer);
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer);
        scanWriter.openScan(scan);
        scanWriter.writeRepository(new Repository(null, config.getRepositoryId(), config.getRepositoryName(), config.getRepositoryFormat(), null));
        scanWriter.writeConfiguration(scan.getConfiguration());
        Selector proprietarySelector = new Config((com.sonatype.insight.scan.model.ScanConfiguration)scan.getConfiguration()).hiddenResourceNamePathSelector;
        int archives = 0;
        int files = 0;
        int classFiles = 0;
        for (RepositoryItem item : config.getScanItems()) {
            if (!moduleIds.contains(item.getCoordinates().getModuleId())) continue;
            try {
                XmlStreamReader reader = ReaderFactory.newXmlReader(new GZIPInputStream(item.newInputStream()));
                Throwable throwable = null;
                try {
                    MXParser parser = new MXParser();
                    parser.setInput(reader);
                    int event = parser.getEventType();
                    while (event != 1) {
                        if (event == 2) {
                            String tag = parser.getName();
                            if (parser.getDepth() == 1) {
                                if (!"scan".equals(tag)) {
                                    throw new XmlPullParserException("Unexpected root tag: " + tag, parser, null);
                                }
                                String version = parser.getAttributeValue(null, "version");
                                if (!scan.getVersion().equals(version)) {
                                    log.warn("Unexpected file format in " + item.getPath() + ", scan might be inaccurate, please ensure the employed Nexus IQ client tools are compatible");
                                }
                            } else if (parser.getDepth() == 2 && "configuration".equals(tag)) {
                                parser.skipSubTree();
                            } else if (parser.getDepth() == 2 && "summary".equals(tag)) {
                                parser.skipSubTree();
                            } else if (parser.getDepth() == 3 && "dir".equals(tag) && !Boolean.parseBoolean(parser.getAttributeValue(null, "dependency")) && this.isNotPresentInRepo(parser.getAttributeValue(null, "sha1"), componentHashes)) {
                                parser.skipSubTree();
                            } else {
                                xmlWriter.startElement(tag);
                                boolean filterPath = "item".equals(tag);
                                int n = parser.getAttributeCount();
                                for (int i = 0; i < n; ++i) {
                                    String name = parser.getAttributeName(i);
                                    String value = parser.getAttributeValue(i);
                                    if (filterPath && "path".equals(name) && value != null && proprietarySelector.isSelected(value) != Selector.Selection.SELECTED) {
                                        xmlWriter.addAttribute("noPathReason", proprietarySelector.getName());
                                        continue;
                                    }
                                    xmlWriter.addAttribute(name, value);
                                }
                                if ("dir".equals(tag)) {
                                    ++archives;
                                    if (!Boolean.parseBoolean(parser.getAttributeValue(null, "dependency"))) {
                                        scannedHashes.add(this.normalizeSha1(parser.getAttributeValue(null, "sha1")));
                                    }
                                } else if ("item".equals(tag)) {
                                    ++files;
                                    String path = parser.getAttributeValue(null, "path");
                                    if (path != null && path.endsWith(".class")) {
                                        ++classFiles;
                                    }
                                }
                            }
                        } else if (event == 3) {
                            if (parser.getDepth() > 1) {
                                xmlWriter.endElement();
                            }
                        } else if (event == 4) {
                            xmlWriter.writeText(parser.getText());
                        }
                        event = parser.next();
                    }
                }
                catch (Throwable parser) {
                    throwable = parser;
                    throw parser;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable parser) {
                            throwable.addSuppressed(parser);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (XmlPullParserException e) {
                throw new IOException("Could not read scan file " + item.getPath(), e);
            }
        }
        summary.setArchives(archives);
        summary.setFiles(files);
        summary.setClassFiles(classFiles);
        FileScanner fileScanner = Bindings.fileScanner();
        ScanSession scanSession = new ScanSession(scan, scanWriter);
        for (RepositoryItem item : componentItems) {
            if (scannedHashes.contains(this.normalizeSha1(item.getSha1()))) continue;
            File file = item.getFile();
            File tmp = null;
            try {
                if (file == null) {
                    String ext = new File(item.getPath()).getName();
                    ext = ext.substring(ext.indexOf(46) + 1);
                    file = tmp = Files.createTempFile(config.getWorkDir().toPath(), "sonatype-clm-file-", "." + ext, new FileAttribute[0]).toFile();
                    try (InputStream is = item.newInputStream();
                         FileOutputStream fos = new FileOutputStream(file);){
                        IOUtils.copy(is, (OutputStream)fos);
                    }
                }
                FileScanRequest scanRequest = new FileScanRequest(scanSession);
                scanRequest.addFile(file, this.trimLeadingSlash(item.getPath()), item.getCoordinates().getId());
                fileScanner.scan(scanRequest);
            }
            finally {
                if (tmp == null) continue;
                try {
                    new FileCleaner().delete(tmp);
                }
                catch (FileCleaner.FileDeletionException fde) {
                    log.error("Unable to delete temporary file: {}", tmp, (Object)fde);
                }
            }
        }
        summary.setEndTime();
        scanWriter.writeSummary(summary);
        scanWriter.closeScan();
    }

    private boolean isNotPresentInRepo(String sha1, Set<SHA1> componentHashes) {
        return sha1 != null && !componentHashes.contains(this.normalizeSha1(sha1));
    }

    private SHA1 normalizeSha1(String sha1) {
        return sha1 != null ? SHA1.fromHexString(sha1) : null;
    }

    private String trimLeadingSlash(String path) {
        return path != null && path.startsWith("/") ? path.substring(1) : path;
    }

    private com.sonatype.insight.scan.model.ScanConfiguration getConfiguration(ScanConfiguration config) throws IOException {
        Properties properties = new Properties();
        if (config.getProprietaryConfig() != null) {
            ProprietaryConfig proprietaryConfig = config.getProprietaryConfig();
            properties.put("proprietaryPackages", StringUtils.join(proprietaryConfig.getPackages().iterator(), ","));
            properties.put("proprietaryRegexes", StringUtils.join(proprietaryConfig.getRegexes().iterator(), ":::"));
        }
        properties.putAll((Map<?, ?>)config.getScanOptions());
        ScanPropertiesLoader loader = new ScanPropertiesLoader();
        loader.resolveAliases(properties);
        loader.loadDefaults(properties, CONFIGURATION_RESOURCE);
        return new com.sonatype.insight.scan.model.ScanConfiguration(properties);
    }

    private static class HashedRepositoryItem
    extends RepositoryItem {
        private final RepositoryItem delegate;
        private final String sha1;

        public HashedRepositoryItem(RepositoryItem delegate, String sha1) {
            this.delegate = delegate;
            this.sha1 = sha1;
        }

        @Override
        public String getSha1() {
            return this.sha1;
        }

        @Override
        public File getFile() {
            return this.delegate.getFile();
        }

        @Override
        public String getPath() {
            return this.delegate.getPath();
        }

        @Override
        public RepositoryItem.Coords getCoordinates() {
            return this.delegate.getCoordinates();
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.delegate.newInputStream();
        }
    }
}

