/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.archive;

import com.sonatype.insight.scan.archive.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompoundSelector
implements Selector {
    private final List<Selector> selectors;
    private final String name;

    public CompoundSelector(String name, Selector ... selectors) {
        this.selectors = Arrays.asList(selectors);
        this.name = name;
    }

    @Override
    public Selector.Selection isSelected(String path) {
        ArrayList<Selector.Selection> answers = new ArrayList<Selector.Selection>();
        for (Selector selector : this.selectors) {
            answers.add(selector.isSelected(path));
        }
        if (answers.contains((Object)Selector.Selection.EXCLUDED)) {
            return Selector.Selection.EXCLUDED;
        }
        if (answers.contains((Object)Selector.Selection.NOT_INCLUDED)) {
            return Selector.Selection.NOT_INCLUDED;
        }
        return Selector.Selection.SELECTED;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

