/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.BowerDependencies;
import com.sonatype.insight.scan.manifest.BowerDependency;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import zz.com.google.gson.Gson;
import zz.com.google.gson.GsonBuilder;
import zz.com.google.gson.JsonElement;
import zz.com.google.gson.JsonParser;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;

public class BowerProcessor {
    private static final Pattern EXCLUDE_VERSION_PREFIX_PATTERN = Pattern.compile("^(>|<|~|\\^)");
    private final Logger log;
    private final FileVisitor fileVisitor;
    private final BowerDependencies.BowerDependenciesDeserializer deserializer = new BowerDependencies.BowerDependenciesDeserializer();
    private final BowerDependencies.BowerDependenciesSerializer serializer = new BowerDependencies.BowerDependenciesSerializer();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public BowerProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(TFile file) {
        this.log.debug("Processing bower file: {}", (Object)file.getAbsolutePath());
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(file), StandardCharsets.UTF_8);){
            BowerDependencies bowerDependencies = this.deserializer.deserialize(JsonParser.parseReader(reader));
            if (bowerDependencies.dependencies != null && bowerDependencies.dependencies.size() > 0) {
                this.filterByVersionAndSensitiveContent(bowerDependencies);
                JsonElement serializeDependencies = this.serializer.serialize(bowerDependencies);
                String string = gson.toJson(serializeDependencies);
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void filterByVersionAndSensitiveContent(BowerDependencies dependencies) {
        Iterator<BowerDependency> it = dependencies.dependencies.iterator();
        while (it.hasNext()) {
            BowerDependency dependency = it.next();
            Matcher matcher = EXCLUDE_VERSION_PREFIX_PATTERN.matcher(dependency.version);
            if (matcher.find()) {
                it.remove();
                continue;
            }
            if (this.fileVisitor.includeResourceName(dependency.name)) continue;
            this.log.debug("Not including bower component '{}'.", (Object)dependency.name);
            it.remove();
        }
    }
}

