/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.DockerImageFileVisitor;
import com.sonatype.insight.scan.file.DockerUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class DockerImageVisitor
extends FileVisitor {
    private Set<File> visitedPaths = new HashSet<File>();
    Set<File> removedPaths = new HashSet<File>();

    public DockerImageVisitor(FileVisitor fileVisitor) {
        super(fileVisitor);
    }

    @Override
    public FileVisitor enterDirectory(File directory, String path) throws IOException {
        FileVisitor visitor = super.enterDirectory(directory, path);
        if (visitor != null) {
            return new DockerImageFileVisitor(this, visitor);
        }
        return null;
    }

    public boolean shouldScanItem(String itemPathRelativeToLayer) {
        boolean isRemoved = DockerUtils.isRemoved(itemPathRelativeToLayer);
        File relativePath = this.getRelativeFile(itemPathRelativeToLayer, isRemoved);
        if (this.visitedPaths.contains(relativePath)) {
            return false;
        }
        this.visitedPaths.add(relativePath);
        if (isRemoved) {
            this.removedPaths.add(relativePath);
        }
        return !isRemoved;
    }

    private File getRelativeFile(String itemPathRelativeToLayer, boolean isRemoved) {
        File relativePath = new File(itemPathRelativeToLayer);
        return isRemoved ? this.removeWhiteoutPrefix(relativePath) : relativePath;
    }

    private File removeWhiteoutPrefix(File relativePath) {
        return new File(relativePath.getParentFile(), relativePath.getName().substring(".wh.".length()));
    }

    public boolean isPathRemoved(File file) {
        return this.removedPaths.contains(file);
    }
}

