/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.DockerImageVisitor;
import com.sonatype.insight.scan.file.FileVisitor;
import java.io.File;
import java.io.IOException;
import zz.de.schlichtherle.truezip.file.TFile;

public class DockerLayerFileVisitor
extends FileVisitor {
    private final DockerImageVisitor dockerImageVisitor;
    private final int layerPathLength;

    public DockerLayerFileVisitor(DockerImageVisitor dockerImageVisitor, FileVisitor fileVisitor, int layerPathLength) {
        super(fileVisitor);
        this.dockerImageVisitor = dockerImageVisitor;
        this.layerPathLength = layerPathLength;
    }

    @Override
    public FileVisitor enterDirectory(File directory, String path) throws IOException {
        TFile tfile = (TFile)directory;
        if (tfile.isArchive() && !this.shouldScanItem(path)) {
            return null;
        }
        if (this.dockerImageVisitor.isPathRemoved(new File(path.substring(this.layerPathLength)))) {
            return null;
        }
        FileVisitor fileVisitor = super.enterDirectory(directory, path);
        return fileVisitor != null ? new DockerLayerFileVisitor(this.dockerImageVisitor, fileVisitor, this.layerPathLength) : null;
    }

    @Override
    public void visitFile(File file, String path) throws IOException {
        if (!this.shouldScanItem(path)) {
            return;
        }
        super.visitFile(file, path);
    }

    private boolean shouldScanItem(String path) {
        return this.dockerImageVisitor.shouldScanItem(path.substring(this.layerPathLength));
    }
}

