/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.archive.Selector;
import com.sonatype.insight.scan.archive.TFileUtils;
import com.sonatype.insight.scan.file.CannotCalculateChecksumException;
import com.sonatype.insight.scan.file.Config;
import com.sonatype.insight.scan.file.ContainerFileProcessor;
import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.InaccessibleFileException;
import com.sonatype.insight.scan.file.ManifestContentProcessor;
import com.sonatype.insight.scan.file.ScanSession;
import com.sonatype.insight.scan.file.ScanUtils;
import com.sonatype.insight.scan.file.Stats;
import com.sonatype.insight.scan.hash.Digester;
import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.DirectoryScanItem;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.ScanItemContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import zz.de.schlichtherle.truezip.file.TArchiveDetector;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;

class FileVisitor {
    private static final Marker PATHS = MarkerFactory.getDetachedMarker((String)"PATHS");
    protected final Logger log;
    private final Digester digester;
    private final Anonymizer anonymizer;
    private final Config config;
    private final Stats stats;
    protected final ScanItemContainer items;
    private final boolean included;
    protected final int parentPath;
    private final int scanDepth;
    private final int symlinkDepth;
    private final String prefix;
    private final String id;
    private final boolean dependency;
    private final Map<File, Boolean> directoryMap = new HashMap<File, Boolean>();
    private final ManifestContentProcessor manifestContentProcessor;
    private final ContainerFileProcessor containerFileProcessor;
    private final ScanSession scanSession;
    private static boolean throwTestErrors = false;

    public FileVisitor(ScanSession scanSession, ScanItemContainer container, String prefix, String id, Stats stats, Digester digester, Anonymizer anonymizer, Logger log) {
        this(scanSession, container, prefix, id, false, stats, digester, anonymizer, log);
    }

    public FileVisitor(ScanSession scanSession, ScanItemContainer container, String prefix, String id, boolean dependency, Stats stats, Digester digester, Anonymizer anonymizer, Logger log) {
        this(scanSession, container, new Config(scanSession.getScan().getConfiguration()), prefix, id, dependency, stats, digester, anonymizer, log);
    }

    private FileVisitor(ScanSession scanSession, ScanItemContainer items, Config config, String prefix, String id, boolean dependency, Stats stats, Digester digester, Anonymizer anonymizer, Logger log) {
        this(scanSession, items, -1, 0, 0, Selector.Selection.SELECTED.equals((Object)config.dirSelector.isSelected("")), prefix, id, dependency, config, stats, digester, anonymizer, log, new ManifestContentProcessor(config, anonymizer, digester, log), new ContainerFileProcessor(log, scanSession));
    }

    protected FileVisitor(FileVisitor fileVisitor) {
        this(fileVisitor.scanSession, fileVisitor.items, fileVisitor.parentPath, fileVisitor.scanDepth, fileVisitor.symlinkDepth, fileVisitor.included, fileVisitor.prefix, fileVisitor.id, fileVisitor.dependency, fileVisitor.config, fileVisitor.stats, fileVisitor.digester, fileVisitor.anonymizer, fileVisitor.log, fileVisitor.manifestContentProcessor, fileVisitor.containerFileProcessor);
    }

    FileVisitor(ScanSession scanSession, ScanItemContainer items, int parentPath, int scanDepth, int symlinkDepth, boolean included, String prefix, String id, boolean dependency, Config config, Stats stats, Digester digester, Anonymizer anonymizer, Logger log, ManifestContentProcessor manifestContentProcessor, ContainerFileProcessor containerFileProcessor) {
        this.scanSession = scanSession;
        this.items = items;
        this.parentPath = parentPath;
        this.scanDepth = scanDepth;
        this.symlinkDepth = symlinkDepth;
        this.included = included;
        this.prefix = prefix;
        this.id = id;
        this.dependency = dependency;
        this.config = config;
        this.stats = stats;
        this.digester = digester;
        this.anonymizer = anonymizer;
        this.log = log;
        this.manifestContentProcessor = manifestContentProcessor;
        this.containerFileProcessor = containerFileProcessor;
    }

    ScanSession getScanSession() {
        return this.scanSession;
    }

    private String concat(String base, String path) {
        if (base == null || base.isEmpty()) {
            return path;
        }
        if (path == null || path.isEmpty()) {
            return base;
        }
        return base + '/' + path;
    }

    private String getPrefixedPath(String path) {
        return this.concat(this.prefix, path);
    }

    private String getPathToLog(File file, String path) {
        return this.dependency ? file.getAbsolutePath() : this.getPrefixedPath(path);
    }

    private void handleError(File file, Exception e, ScanItem item, String path) {
        ScanUtils.handleError(this.stats, e, item, this.getPathToLog(file, path), this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void visitFile(File file, String path) throws IOException {
        DirectoryScanItem item;
        block30: {
            block29: {
                block28: {
                    item = null;
                    try {
                        Selector.Selection selection;
                        TFile tfile;
                        block27: {
                            tfile = (TFile)file;
                            if (tfile.isArchive()) {
                                this.log.warn("Could not open {} as an archive. Will scan it as regular file.", (Object)this.getPathToLog(file, path));
                            }
                            if (tfile.getArchiveDetector().getScheme(tfile.getName()) != null && !Selector.Selection.EXCLUDED.equals((Object)this.config.dirSelector.isSelected(path))) {
                                try {
                                    TFileInputStream is = new TFileInputStream(file);
                                    Throwable throwable = null;
                                    if (is == null) break block27;
                                    if (throwable != null) {
                                        try {
                                            ((InputStream)is).close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    } else {
                                        ((InputStream)is).close();
                                    }
                                }
                                catch (IOException e) {
                                    this.stats.inaccessibleFiles.incrementAndGet();
                                    item = new DirectoryScanItem();
                                    if (this.config.hiddenArchiveNamesPathSelector.isSelected(this.getPrefixedPath(path)) != Selector.Selection.SELECTED) throw new InaccessibleFileException(this.getPathToLog(file, path), e);
                                    this.setScanItemPath((ScanItem)item, path);
                                    throw new InaccessibleFileException(this.getPathToLog(file, path), e);
                                }
                            }
                        }
                        if (!Selector.Selection.SELECTED.equals((Object)(selection = this.included ? this.config.fileSelector.isSelected(path) : Selector.Selection.NOT_INCLUDED))) {
                            this.log.debug("Not visiting {}, {}", (Object)this.getPathToLog(file, path), (Object)selection);
                            if (FileUtils.isIacFile(file)) return;
                            break block28;
                        }
                        boolean includeResourceName = this.includeResourceName(path);
                        if (!includeResourceName && !this.config.hashFiles) {
                            this.log.debug("includeResourceName and config.hashFiles were false. Not visiting {}", (Object)this.getPathToLog(file, path));
                            if (FileUtils.isIacFile(file)) return;
                            break block29;
                        }
                        this.log.debug("Visiting {}", (Object)this.getPathToLog(file, path));
                        if (!FileUtils.isIacFile(file)) {
                            this.stats.files.incrementAndGet();
                        }
                        if (path.endsWith(".class")) {
                            this.stats.classFiles.incrementAndGet();
                        }
                        item = new ScanItem();
                        if (throwTestErrors) {
                            throw new RuntimeException("InsightFileVisitor.visitFile error on " + path);
                        }
                        if (this.dependency && this.scanDepth <= 0) {
                            item.setDependency(true);
                            item.setId(this.id);
                        }
                        if (includeResourceName) {
                            this.setScanItemPath((ScanItem)item, path);
                        } else {
                            item.setNoPathReason(this.config.hiddenResourceNamePathSelector.getName());
                            if (this.config.nameHashes) {
                                this.setScanItemNameHash((ScanItem)item, tfile);
                            }
                        }
                        if (this.config.fileSizes) {
                            this.setScanItemSize((ScanItem)item, tfile);
                        }
                        item.setLastModified(tfile.lastModified());
                        if (this.config.hashFiles && !this.isNeuVectorContainerFile(file) && !FileUtils.isIacFile(file)) {
                            this.setScanItemHash((ScanItem)item, tfile, path);
                        }
                        this.manifestContentProcessor.setScanItemContent((ScanItem)item, tfile, this.buildProcessorFileVisitor());
                        if (FileUtils.isIacFile(file)) return;
                        break block30;
                    }
                    catch (RuntimeException e) {
                        this.handleError(file, e, (ScanItem)item, path);
                        return;
                    }
                }
                this.addScanItem((ScanItem)item);
                return;
            }
            this.addScanItem((ScanItem)item);
            return;
        }
        this.addScanItem((ScanItem)item);
        return;
        finally {
            if (!FileUtils.isIacFile(file)) {
                this.addScanItem((ScanItem)item);
            }
        }
    }

    Function<File, Boolean> shouldScanFile() {
        return file -> {
            if (file == null) {
                return false;
            }
            String filePath = file.getAbsolutePath();
            Selector.Selection selection = this.config.fileSelector.isSelected(filePath);
            if (!Selector.Selection.SELECTED.equals((Object)selection)) {
                this.log.info("Not scanning {}", (Object)filePath);
                return false;
            }
            return true;
        };
    }

    private boolean isNeuVectorContainerFile(File file) {
        return file.getPath().startsWith("container:");
    }

    protected boolean includeResourceName(String path) {
        if (this.config.hiddenResourceNamePathSelector.isSelected(this.getPathForScanItem(path)) == Selector.Selection.SELECTED) {
            return this.config.proprietaryRegexSelector.isSelected(this.getPrefixedPath(path)) == Selector.Selection.SELECTED;
        }
        return false;
    }

    protected FileVisitor enterDirectory(File directory, String path) throws IOException {
        DirectoryScanItem item = null;
        try {
            Selector.Selection selection = this.config.dirSelector.isSelected(path);
            boolean included = Selector.Selection.SELECTED.equals((Object)selection);
            if (path.isEmpty()) {
                selection = Selector.Selection.SELECTED;
            }
            if (Selector.Selection.EXCLUDED.equals((Object)selection)) {
                this.log.debug("Not entering {}, {}", (Object)this.getPathToLog(directory, path), (Object)selection);
                return null;
            }
            TFile tfile = (TFile)directory;
            if (!tfile.isArchive() || Selector.Selection.SELECTED.equals((Object)selection)) {
                this.log.debug("Scanning {}...", (Object)this.getPathToLog(directory, path));
            }
            ScanItemContainer items = this.items;
            int parentPath = this.parentPath;
            int scanDepth = this.scanDepth;
            int symlinkDepth = this.symlinkDepth;
            if (this.isSymlink(tfile, path)) {
                this.log.debug("Detected symlink {}", (Object)this.getPathToLog(directory, path));
                if (!tfile.isArchive()) {
                    ++symlinkDepth;
                }
                this.stats.symlinks.incrementAndGet();
            }
            TFile barefile = new TFile((File)tfile.getParentFile(), tfile.getName(), TArchiveDetector.NULL);
            if (tfile.isArchive() && barefile.isFile()) {
                ++scanDepth;
                if (Selector.Selection.SELECTED.equals((Object)selection)) {
                    boolean isProprietary;
                    boolean archiveName;
                    this.log.debug(PATHS, "Scanning {}...", (Object)this.getPathToLog(directory, path));
                    this.stats.archives.incrementAndGet();
                    item = new DirectoryScanItem();
                    if (scanDepth <= 1) {
                        item.setDependency(this.dependency);
                    }
                    if (this.id != null && scanDepth <= 1) {
                        item.setId(this.id);
                    }
                    boolean bl = archiveName = this.config.hiddenArchiveNamesPathSelector.isSelected(this.getPrefixedPath(path)) == Selector.Selection.SELECTED;
                    if (archiveName) {
                        this.setScanItemPath((ScanItem)item, path);
                    } else if (this.config.nameHashes) {
                        this.setScanItemNameHash((ScanItem)item, tfile);
                    }
                    boolean bl2 = isProprietary = this.config.proprietaryRegexSelector.isSelected(this.getPrefixedPath(path)) == Selector.Selection.EXCLUDED;
                    if (isProprietary) {
                        item.setProprietary(Boolean.valueOf(true));
                    }
                    if (this.config.fileSizes) {
                        this.setScanItemSize((ScanItem)item, tfile);
                    }
                    item.setLastModified(tfile.lastModified());
                    if (this.config.hashFiles) {
                        this.setScanItemHash((ScanItem)item, tfile, path);
                        Set<String> fileHashes = this.scanSession.getFileHashes();
                        if (fileHashes != null) {
                            if (fileHashes.contains(item.getSha1())) {
                                this.log.debug("Adding reference to file {} with a hash of {} that has already been scanned", (Object)item.getPath(), (Object)item.getSha1());
                                this.addScanItem((ScanItem)item);
                                return null;
                            }
                            fileHashes.add(item.getSha1());
                        }
                    }
                    if (this.config.pomProperties) {
                        this.processPomProperties((ScanItem)item, tfile);
                    }
                    this.startDir(item, directory);
                    items = item;
                    int n = parentPath = !path.isEmpty() ? path.length() + 1 : 0;
                    if (path.endsWith(".jar") && !this.config.resourceDetails) {
                        return null;
                    }
                }
            } else if (tfile.getEnclArchive() == null) {
                this.stats.directories.incrementAndGet();
                ++scanDepth;
            }
            if (scanDepth > this.config.maxDepth) {
                this.log.info("Not recursing into {}, maximum scan depth reached", (Object)this.getPathToLog(directory, path));
                return null;
            }
            if (symlinkDepth > this.config.maxSymlinkDepth) {
                this.log.info("Not recursing into {}, maximum symlink depth reached", (Object)this.getPathToLog(directory, path));
                return null;
            }
            if (items != this.items || scanDepth != this.scanDepth || symlinkDepth != this.symlinkDepth || included != this.included) {
                return new FileVisitor(this.scanSession, items, parentPath, scanDepth, symlinkDepth, included, this.prefix, this.id, this.dependency, this.config, this.stats, this.digester, this.anonymizer, this.log, this.manifestContentProcessor, this.containerFileProcessor);
            }
            if (throwTestErrors) {
                throw new RuntimeException("InsightFileVisitor.enterDirectory error on " + path);
            }
        }
        catch (RuntimeException e) {
            this.handleError(directory, e, (ScanItem)item, path);
        }
        return this;
    }

    void leaveDirectory(File directory, String path) throws IOException {
        this.endDir(directory);
        ScanUtils.unmount((TFile)directory, this.log, this.getPathToLog(directory, path));
    }

    private boolean isSymlink(TFile file, String path) {
        if (file.getEnclArchive() != null) {
            return false;
        }
        try {
            TFile parent = file.getAbsoluteFile().getParentFile();
            File f = parent == null ? file : new File(((File)parent).getCanonicalFile(), file.getName());
            return !((File)f).getCanonicalFile().equals(((File)f).getAbsoluteFile());
        }
        catch (IOException e) {
            this.log.warn("Failed to test {} for symlink: {}", (Object)this.getPathToLog(file, path), (Object)e.getMessage());
            this.log.debug("Error details", (Throwable)e);
            return false;
        }
    }

    private void processPomProperties(ScanItem item, TFile file) {
        TFile maven = new TFile((File)file, "META-INF/maven");
        File[] gids = ((File)maven).listFiles();
        if (gids != null) {
            for (File gid : gids) {
                File[] aids = gid.listFiles();
                if (aids == null) continue;
                for (File aid : aids) {
                    TFile propFile = new TFile(aid, "pom.properties");
                    if (!propFile.isFile()) continue;
                    try (TFileInputStream is = new TFileInputStream(propFile);){
                        Properties pomProps = new Properties();
                        pomProps.load(is);
                        String groupId = pomProps.getProperty("groupId", "");
                        String artifactId = pomProps.getProperty("artifactId", "");
                        String version = pomProps.getProperty("version", "");
                        ArtifactId id = ArtifactId.maven((String)groupId, (String)artifactId, (String)version);
                        if (this.config.anonymizeArtifactIds) {
                            id.setId(this.anonymizer.anonymizeArtifactId(id.getId()));
                        }
                        item.addId(id);
                    }
                    catch (IOException e) {
                        this.log.warn("Failed to read {}: {}", (Object)propFile, (Object)e.getMessage());
                        this.log.debug("Error details", (Throwable)e);
                    }
                }
            }
        }
    }

    private void setScanItemPath(ScanItem item, String path) {
        String itemPath = this.getPathForScanItem(path);
        item.setPath(itemPath);
    }

    private String getPathForScanItem(String path) {
        if (this.parentPath < 0) {
            return this.getPrefixedPath(path);
        }
        return path.substring(this.parentPath);
    }

    private void setScanItemSize(ScanItem item, TFile file) {
        long itemSize = TFileUtils.dataLength(file);
        item.setSize(itemSize);
    }

    private void setScanItemNameHash(ScanItem item, TFile file) {
        String nameHash = this.anonymizer.hash(file.getName());
        item.setNameSha1(nameHash);
    }

    private void setScanItemHash(ScanItem item, TFile file, String path) {
        try {
            ScanUtils.setHash(item, file, this.digester, this.config);
        }
        catch (Exception e) {
            throw new CannotCalculateChecksumException(this.getPathToLog(file, path), e);
        }
    }

    private void startDir(DirectoryScanItem item, File file) throws IOException {
        if (this.scanSession.getScanWriter() != null) {
            this.directoryMap.put(file, true);
            this.scanSession.getScanWriter().openDirectoryScanItem(item, file);
        } else {
            this.addScanItem((ScanItem)item);
        }
    }

    private void endDir(File file) throws IOException {
        if (this.scanSession.getScanWriter() != null && this.directoryMap.containsKey(file)) {
            this.scanSession.getScanWriter().closeDirectoryScanItem(file);
            this.directoryMap.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanItem(ScanItem item) throws IOException {
        if (item != null) {
            if (this.scanSession.getScanWriter() != null) {
                this.scanSession.getScanWriter().writeScanItem(item);
            } else {
                ScanItemContainer scanItemContainer = this.items;
                synchronized (scanItemContainer) {
                    this.items.addItem(item);
                }
            }
        }
    }

    private FileVisitor buildProcessorFileVisitor() {
        return new FileVisitor(this.scanSession, this.items, -1, this.scanDepth, this.symlinkDepth, this.included, this.prefix, this.id, this.dependency, this.config, this.stats, this.digester, this.anonymizer, this.log, this.manifestContentProcessor, this.containerFileProcessor);
    }

    public static void setThrowTestErrors(boolean throwTestErrors) {
        FileVisitor.throwTestErrors = throwTestErrors;
    }

    public String processContainerFile(TFile file) {
        return this.containerFileProcessor.process(file);
    }

    public Stats getStats() {
        return this.stats;
    }

    public ScanItemContainer getItems() {
        return this.items;
    }
}

