/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.SbomUtils;
import com.sonatype.insight.scan.tools.manifests.gradle.model.BuildModel;
import com.sonatype.insight.scan.tools.manifests.gradle.model.ExternalDependency;
import com.sonatype.insight.scan.tools.manifests.gradle.model.Property;
import com.sonatype.insight.scan.tools.manifests.gradle.model.Version;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.GroovyBuildFileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.cyclonedx.model.Component;

public class GradleBuildProcessor {
    private static final List<String> SUPPORTED_JAVA_COMPILE_CONFIGURATIONS = Arrays.asList("api", "apiElements", "compileClasspath", "implementation", "compileOnly", "compileOnlyApi", "compile");
    private static final Pattern VERSION_RANGE_CHARACTERS = Pattern.compile("[+()\\[]");
    private final Logger log;
    private final FileVisitor fileVisitor;
    private final GroovyBuildFileReader buildFileReader = new GroovyBuildFileReader();

    public GradleBuildProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public String process(TFile file) {
        this.log.debug("Processing build.gradle file: {}", (Object)file.getAbsolutePath());
        try {
            BuildModel buildModel = this.buildFileReader.read(file);
            ArrayList<Component> components = new ArrayList<Component>();
            HashSet<ExternalDependency> dependenciesWithMissingVersions = new HashSet<ExternalDependency>();
            for (ExternalDependency dependency : buildModel.getDependencies()) {
                if (!this.isSupportedCompileConfiguration(dependency) || this.isSensitiveContent(dependency)) continue;
                if (this.isDeclaredInDependencySection(dependency)) {
                    if (dependency.getVersionString() == null) {
                        dependenciesWithMissingVersions.add(dependency);
                        continue;
                    }
                    this.processDependency(buildModel, dependency, components);
                    continue;
                }
                if (!this.isDeclaredInConstraintsSection(dependency) || !this.isVersionSuppliedByDependencyDeclaredInConstraint(dependency, dependenciesWithMissingVersions)) continue;
                this.processDependency(buildModel, dependency, components);
            }
            return SbomUtils.createSbomXmlString(components);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSensitiveContent(ExternalDependency dependency) {
        return !this.fileVisitor.includeResourceName(dependency.getGroup()) || !this.fileVisitor.includeResourceName(dependency.getName());
    }

    private boolean isSupportedCompileConfiguration(ExternalDependency dependency) {
        return SUPPORTED_JAVA_COMPILE_CONFIGURATIONS.contains(dependency.getConfigurationName());
    }

    private boolean isDependencyValid(ExternalDependency dependency) {
        if (StringUtils.isBlank(dependency.getGroup()) || StringUtils.isBlank(dependency.getName()) || StringUtils.isBlank(dependency.getExtension())) {
            return false;
        }
        if (dependency.getVersion() == null || StringUtils.isBlank(dependency.getVersionString())) {
            return false;
        }
        Matcher matcher = VERSION_RANGE_CHARACTERS.matcher(dependency.getVersionString());
        return !matcher.find();
    }

    private boolean isDeclaredInDependencySection(ExternalDependency dependency) {
        return Objects.equals("dependencies", dependency.getCallPath());
    }

    private boolean isDeclaredInConstraintsSection(ExternalDependency dependency) {
        return Objects.equals("dependencies.constraints", dependency.getCallPath());
    }

    private boolean isVersionSuppliedByDependencyDeclaredInConstraint(ExternalDependency dependency, Set<ExternalDependency> dependenciesWithoutVersion) {
        for (ExternalDependency other : dependenciesWithoutVersion) {
            if (!Objects.equals(dependency.getGroup(), other.getGroup()) || !Objects.equals(dependency.getName(), other.getName()) || !Objects.equals(dependency.getClassifier(), other.getClassifier()) || !Objects.equals(dependency.getExtension(), other.getExtension())) continue;
            return true;
        }
        return false;
    }

    private void processDependency(BuildModel buildModel, ExternalDependency dependency, List<Component> components) {
        List<Property> properties = buildModel.getProperties();
        dependency.setGroup(this.resolveValueFromProperties(dependency.getGroup(), properties));
        dependency.setName(this.resolveValueFromProperties(dependency.getName(), properties));
        dependency.setExtension(this.resolveValueFromProperties(dependency.getExtension(), properties));
        if (dependency.getVersionString().startsWith("$")) {
            Version version = this.resolveVersionFromProperties(dependency.getVersion(), properties);
            dependency.setVersion(version);
        }
        if (this.isDependencyValid(dependency)) {
            if (StringUtils.isNotBlank(dependency.getClassifier())) {
                String classifier = this.resolveValueFromProperties(dependency.getClassifier(), properties);
                if (StringUtils.isNotBlank(classifier)) {
                    dependency.setClassifier(classifier);
                    this.createComponent(dependency, components);
                }
            } else {
                this.createComponent(dependency, components);
            }
        }
    }

    private Version resolveVersionFromProperties(Version version, List<Property> properties) {
        String value = this.resolveValueFromProperties(version.getValue(), properties);
        if (value == null) {
            return null;
        }
        Version update = new Version(value);
        update.setPrefer(version.getPrefer());
        update.setReject(version.getReject());
        update.setRequire(version.getRequire());
        update.setStrictly(version.getStrictly());
        return update;
    }

    private String resolveValueFromProperties(String value, List<Property> properties) {
        if (value != null && value.startsWith("$")) {
            String propertyValue = value.replaceAll("[${}]", "");
            for (Property property : properties) {
                if (!Objects.equals(propertyValue, property.getName())) continue;
                return property.getValue();
            }
            return null;
        }
        return value;
    }

    private void createComponent(ExternalDependency dependency, List<Component> components) {
        try {
            Component component = SbomUtils.createLibraryComponent(dependency.getName(), dependency.getVersionString());
            component.setGroup(dependency.getGroup());
            component.setScope(Component.Scope.REQUIRED);
            component.setPurl(SbomUtils.createMavenPackageUrl(dependency.getName(), dependency.getGroup(), dependency.getVersionString(), dependency.getExtension(), dependency.getClassifier()));
            components.add(component);
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Invalid coordinates found in the file build.gradle", (Throwable)e);
        }
    }
}

