/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.ScanSession;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleScanRequest {
    private File basedir;
    private String moduleId;
    private String moduleKind;
    private File moduleDir;
    private Map<File, String> consumedFiles;
    private Map<File, String> producedFiles;
    private Map<String, List<String>> dependencies;
    private Set<String> directDependencies;
    private ScanSession scanSession;

    public ModuleScanRequest(ScanSession scanSession) {
        this.scanSession = scanSession;
        this.consumedFiles = new LinkedHashMap<File, String>();
        this.producedFiles = new LinkedHashMap<File, String>();
        this.dependencies = new LinkedHashMap<String, List<String>>();
        this.directDependencies = new HashSet<String>();
    }

    File getBasedir() {
        return this.basedir;
    }

    public ModuleScanRequest setBasedir(File basedir) {
        this.basedir = basedir;
        return this;
    }

    String getModuleId() {
        return this.moduleId;
    }

    String getModuleKind() {
        return this.moduleKind;
    }

    File getModuleDir() {
        return this.moduleDir;
    }

    public ModuleScanRequest setModule(String id, String kind, File dir) {
        this.moduleId = id;
        this.moduleKind = kind;
        this.moduleDir = dir;
        return this;
    }

    public ModuleScanRequest setModule(String id, String kind, String dir) {
        return this.setModule(id, kind, dir != null ? new File(dir) : null);
    }

    Map<File, String> getConsumedFiles() {
        return this.consumedFiles;
    }

    Map<File, String> getProducedFiles() {
        return this.producedFiles;
    }

    Map<String, List<String>> getDependencies() {
        return this.dependencies;
    }

    Set<String> getDirectDependencies() {
        return this.directDependencies;
    }

    public ModuleScanRequest addConsumedFile(File file, String id) {
        if (file != null) {
            this.consumedFiles.put(file, id);
        }
        return this;
    }

    public ModuleScanRequest addProducedFile(File file, String id) {
        if (file != null) {
            this.producedFiles.put(file, id);
        }
        return this;
    }

    public ModuleScanRequest addDependency(String id, boolean direct, List<String> children) {
        List<String> currentChildren = this.dependencies.get(id);
        if (currentChildren == null || currentChildren.size() < children.size()) {
            this.dependencies.put(id, children);
        }
        if (direct) {
            this.directDependencies.add(id);
        }
        return this;
    }

    public ScanSession getScanSession() {
        return this.scanSession;
    }
}

