/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.JavascriptPackageJsonProcessor;
import com.sonatype.insight.scan.file.JavascriptScannerResult;
import com.sonatype.insight.scan.file.ScanSession;
import com.sonatype.insight.scan.manifest.NpmDependencies;
import com.sonatype.insight.scan.manifest.NpmDependency;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.google.gson.JsonParser;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.org.apache.commons.io.IOUtils;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.semver4j.Semver;

interface NpmManifestFileReader {
    public static final Logger log = LoggerFactory.getLogger(NpmManifestFileReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String readContent(TFile file) {
        try (TFileInputStream inputStream = new TFileInputStream(file);){
            String string = IOUtils.toString((InputStream)inputStream, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public NpmDependencies read(TFile file, FileVisitor fileVisitor) {
        String content = this.readContent(file);
        if (StringUtils.isBlank(content)) {
            return null;
        }
        boolean scanDevAndOptDependencies = NpmManifestFileReader.shouldScanDevAndOptDependencies(fileVisitor);
        if (scanDevAndOptDependencies) {
            log.debug("NPM optional and development dependency scanning enabled");
        }
        NpmDependencies npmDependencies = new NpmDependencies.NpmDependenciesDeserializer().deserialize(JsonParser.parseString(content), scanDevAndOptDependencies);
        if (npmDependencies.lockfileVersion != null && npmDependencies.lockfileVersion != 1) {
            NpmDependencies filteredNpmDependencies = this.createNpmDependenciesFilteredByPackageJson(file, fileVisitor, npmDependencies.dependencies, scanDevAndOptDependencies);
            if (filteredNpmDependencies.name == null) {
                filteredNpmDependencies.name = npmDependencies.name;
            }
            if (filteredNpmDependencies.version == null) {
                filteredNpmDependencies.version = npmDependencies.version;
            }
            npmDependencies = filteredNpmDependencies;
        }
        return npmDependencies;
    }

    public static boolean shouldScanDevAndOptDependencies(FileVisitor fileVisitor) {
        ScanSession scanSession = fileVisitor.getScanSession();
        if (scanSession.getLicensedFeatures() != null) {
            return scanSession.getLicensedFeatures().contains("scan-npm-dev-and-opt-dependencies");
        }
        return false;
    }

    default public NpmDependencies createNpmDependenciesFilteredByPackageJson(TFile file, FileVisitor fileVisitor, Set<NpmDependency> dependencies) {
        return this.createNpmDependenciesFilteredByPackageJson(file, fileVisitor, dependencies, null);
    }

    default public NpmDependencies createNpmDependenciesFilteredByPackageJson(TFile file, FileVisitor fileVisitor, Set<NpmDependency> dependencies, Boolean scanDevAndOptDependencies) {
        NpmDependencies npmDependencies = new NpmDependencies();
        npmDependencies.dependencies = new LinkedHashSet<NpmDependency>(dependencies);
        JavascriptScannerResult packageJson = new JavascriptPackageJsonProcessor().readPackageJsonGivenSibling(file, fileVisitor.shouldScanFile());
        if (packageJson != null) {
            Map<String, String> directDependencies;
            if (packageJson.getName() != null && packageJson.getVersion() != null) {
                npmDependencies.name = packageJson.getName().toString();
                npmDependencies.version = packageJson.getVersion().toString();
            }
            if (scanDevAndOptDependencies == null) {
                scanDevAndOptDependencies = NpmManifestFileReader.shouldScanDevAndOptDependencies(fileVisitor);
            }
            if ((directDependencies = NpmManifestFileReader.getDirectDependencies(packageJson, scanDevAndOptDependencies)) != null) {
                npmDependencies.dependencies.removeIf(npmDependency -> directDependencies.entrySet().stream().noneMatch(directDependency -> NpmManifestFileReader.npmDependencyMatchesDirectDependency(npmDependency, directDependency)));
            }
        }
        return npmDependencies;
    }

    public static Map<String, String> getDirectDependencies(JavascriptScannerResult packageJson, boolean scanDevAndOptDependencies) {
        HashMap<String, String> dependencies = new HashMap<String, String>();
        if (packageJson == null) {
            return null;
        }
        if (scanDevAndOptDependencies) {
            if (packageJson.getDevDependencies() != null && packageJson.getDevDependencies() instanceof Map) {
                dependencies.putAll((Map)packageJson.getDevDependencies());
            }
            if (packageJson.getOptionalDependencies() != null && packageJson.getOptionalDependencies() instanceof Map) {
                dependencies.putAll((Map)packageJson.getOptionalDependencies());
            }
        }
        if (packageJson.getDependencies() != null && packageJson.getDependencies() instanceof Map) {
            dependencies.putAll((Map)packageJson.getDependencies());
            return dependencies;
        }
        return dependencies.isEmpty() ? null : dependencies;
    }

    public static boolean npmDependencyMatchesDirectDependency(NpmDependency npmDependency, Map.Entry<String, String> directDependency) {
        if (npmDependency.specifiers.isEmpty()) {
            return NpmManifestFileReader.matchesDependency(npmDependency, new NpmDependency(directDependency.getKey(), directDependency.getValue()));
        }
        return npmDependency.packageId.equals(directDependency.getKey()) && npmDependency.specifiers.contains(directDependency.getValue());
    }

    public static boolean matchesDependency(NpmDependency dependency, NpmDependency requiredDep) {
        if (StringUtils.isAnyBlank(dependency.packageId, dependency.version, requiredDep.packageId, requiredDep.version)) {
            return false;
        }
        if (!dependency.packageId.equals(requiredDep.packageId)) {
            return false;
        }
        try {
            return NpmManifestFileReader.satisfies(dependency.version, requiredDep.version);
        }
        catch (Exception e) {
            log.debug("Unable to check semantic version for {}:{} and range {}", new Object[]{dependency.packageId, dependency.version, requiredDep.version, e});
            return dependency.version.equals(requiredDep.version);
        }
    }

    public static String removeQuotes(String input) {
        return input.replaceAll("['\"]", "");
    }

    public static boolean satisfies(String targetVersion, String versionRange) {
        Semver semNPM = new Semver(targetVersion);
        return semNPM.satisfies(versionRange);
    }
}

