/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.PythonDependency;
import com.sonatype.insight.scan.manifest.PythonRequirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.de.schlichtherle.truezip.file.TFile;

public class PythonRequirementsProcessor {
    private final Logger log;
    private static final Pattern COMMENT_PATTERN = Pattern.compile("(^|\\s)+#.*$");
    private static final String[] ALLOWED_OPTIONS = new String[]{"--platform", "--python-version", "--no-binary", "--only-binary", "--implementation", "--abi"};
    private final FileVisitor fileVisitor;
    private static boolean throwTestErrors = false;

    public PythonRequirementsProcessor() {
        this.log = LoggerFactory.getLogger(PythonRequirementsProcessor.class);
        this.fileVisitor = null;
    }

    PythonRequirementsProcessor(FileVisitor fileVisitor) {
        this.log = fileVisitor.log;
        this.fileVisitor = fileVisitor;
    }

    String process(TFile requirementsFile) {
        this.log.debug("Processing Python requirements file: {}", (Object)requirementsFile.getAbsolutePath());
        if (throwTestErrors) {
            throw new RuntimeException("PythonRequirementsProcessor.process error on " + requirementsFile.getPath());
        }
        List<String> lines = FileUtils.readLines(requirementsFile);
        lines = this.removeComments(lines);
        lines = this.removeLineContinuations(lines);
        lines = this.trimLines(lines);
        lines = this.removeEmptyLines(lines);
        lines = this.normalizeWhiteSpace(lines);
        lines = this.filterSensitiveContent(lines);
        return String.join((CharSequence)"\n", lines);
    }

    private List<String> filterSensitiveContent(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            PythonRequirement requirement = PythonRequirement.fromLine(line);
            if (requirement.dependency != null) {
                PythonDependency dependency = PythonDependency.fromString(requirement.dependency);
                if (dependency == null) continue;
                if (!this.fileVisitor.includeResourceName(dependency.name)) {
                    this.log.debug("Not including python dependency '{}'.", (Object)dependency);
                    continue;
                }
                Iterator<String> extrasIterator = dependency.extras.iterator();
                while (extrasIterator.hasNext()) {
                    String extra = extrasIterator.next();
                    if (this.fileVisitor.includeResourceName(extra)) continue;
                    this.log.debug("Not including python dependency extra '{}'.", (Object)extra);
                    extrasIterator.remove();
                }
                requirement.dependency = dependency.toString();
            }
            requirement.options = this.filterOptions(requirement.options);
            if (requirement.isEmpty()) continue;
            result.add(requirement.toString());
        }
        return result;
    }

    private String filterOptions(String optionsString) {
        StringBuilder result = new StringBuilder();
        block0: for (String option : this.splitOptions(optionsString)) {
            for (String allowedOption : ALLOWED_OPTIONS) {
                if (!option.startsWith(allowedOption)) continue;
                if (result.length() > 0) {
                    result.append(' ');
                }
                result.append(option);
                continue block0;
            }
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    private List<String> normalizeWhiteSpace(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            line = line.replace('\t', ' ');
            while (line.contains("  ")) {
                line = line.replace("  ", " ");
            }
            result.add(line);
        }
        return result;
    }

    private List<String> trimLines(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line.trim());
        }
        return result;
    }

    private List<String> removeEmptyLines(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            if (line.isEmpty()) continue;
            result.add(line);
        }
        return result;
    }

    private List<String> removeLineContinuations(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder previousLine = null;
        for (String line : lines) {
            if (line.endsWith("\\") && !line.endsWith("\\\\")) {
                line = line.substring(0, line.length() - 1);
                if (previousLine != null) {
                    previousLine.append(line);
                    continue;
                }
                previousLine = new StringBuilder(line);
                continue;
            }
            if (previousLine != null) {
                line = previousLine + line;
                previousLine = null;
            }
            result.add(line);
        }
        if (previousLine != null) {
            result.add(previousLine.toString());
        }
        return result;
    }

    private List<String> removeComments(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            line = COMMENT_PATTERN.matcher(line).replaceFirst("");
            result.add(line);
        }
        return result;
    }

    private List<String> splitOptions(String optionsString) {
        if (optionsString == null) {
            return Collections.emptyList();
        }
        ArrayList<String> options = new ArrayList<String>();
        int optionAt = 0;
        while ((optionAt = optionsString.lastIndexOf(" -")) > 0) {
            options.add(0, optionsString.substring(optionAt + 1));
            optionsString = optionsString.substring(0, optionAt);
        }
        options.add(0, optionsString);
        return options;
    }

    public static void setThrowTestErrors(boolean throwTestErrors) {
        PythonRequirementsProcessor.throwTestErrors = throwTestErrors;
    }
}

