/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file.nuget.model;

import zz.org.apache.commons.lang3.StringUtils;

public class Reference {
    private String include;
    private String name;
    private String version;

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getName() {
        if (this.name == null) {
            this.deriveNameAndVersion();
        }
        return this.name;
    }

    public String getVersion() {
        if (this.version == null) {
            this.deriveNameAndVersion();
        }
        return this.version;
    }

    private void deriveNameAndVersion() {
        String[] parts;
        if (StringUtils.isNotBlank(this.include) && (parts = StringUtils.split(this.include, ",")) != null && parts.length > 1) {
            this.name = parts[0];
            for (int i = 1; i < parts.length; ++i) {
                String part = StringUtils.trim(parts[i]);
                if (!StringUtils.isNotBlank(part) || !part.startsWith("Version=")) continue;
                this.version = StringUtils.removeStart(part, "Version=");
                return;
            }
        }
        this.name = this.name == null ? "" : this.name;
        this.version = "";
    }
}

