/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash;

import com.sonatype.insight.scan.hash.AbstractSHA1;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.hash.IMatchable;
import java.util.Collection;
import java.util.Collections;

public class Hash
extends AbstractSHA1
implements IMatchable,
Comparable<Hash> {
    private final HashType type;
    private final byte[] extras;

    public Hash(HashType type, byte[] bytes, byte[] extras) {
        super(bytes);
        this.type = type;
        this.extras = extras != null ? (byte[])extras.clone() : null;
    }

    public Hash(HashType type, AbstractSHA1 value) {
        super(value);
        this.type = type;
        this.extras = null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Hash)) {
            return false;
        }
        Hash other = (Hash)obj;
        return this.type.equals((Object)other.type) && Hash.equalsSHA1(this, other);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + ":" + super.toString();
    }

    @Override
    public HashType getType() {
        return this.type;
    }

    public byte[] getExtraStats() {
        return this.extras;
    }

    @Override
    public Collection<Hash> getHashes() {
        return Collections.singleton(this);
    }

    @Override
    public int compareTo(Hash o) {
        return super.compareTo(o);
    }
}

