/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal;

import com.sonatype.insight.scan.hash.Hash;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.hash.IMatchable;
import com.sonatype.insight.scan.hash.MultiHash;
import com.sonatype.insight.scan.hash.internal.asm.AsmClassFactory;
import com.sonatype.insight.scan.hash.internal.asm.AsmClassNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class JavaDigester {
    public static final Set<HashType> SUPPORTED_HASH_TYPES;

    public void digest(Map<HashType, IMatchable> digests, byte[] data, int offset, int length) throws Exception {
        EnumMap<HashType, Set<Hash>> hashes = new EnumMap<HashType, Set<Hash>>(HashType.class);
        AsmClassNode n = AsmClassFactory.newClassNode(data, offset, length);
        boolean hasBytecode = n.hasBytecode();
        if (digests.containsKey((Object)HashType.BYTECODE)) {
            this.addHash(digests, n.getClassHash(HashType.BYTECODE));
        }
        if (digests.containsKey((Object)HashType.METHOD)) {
            hashes.put(HashType.METHOD, n.getMethodHashes(HashType.METHOD));
        }
        n.stripMethodBodies();
        if (hasBytecode && digests.containsKey((Object)HashType.SIGNATURE)) {
            this.addHash(digests, n.getClassHash(HashType.SIGNATURE));
        }
        if (digests.containsKey((Object)HashType.FIELD)) {
            hashes.put(HashType.FIELD, n.getFieldHashes(HashType.FIELD));
        }
        if (digests.containsKey((Object)HashType.METHOD_SIGNATURE)) {
            hashes.put(HashType.METHOD_SIGNATURE, n.getMethodHashes(HashType.METHOD_SIGNATURE));
        }
        n.stripMembers();
        if (digests.containsKey((Object)HashType.TYPE)) {
            this.addHash(digests, n.getClassHash(HashType.TYPE));
        }
        n = AsmClassFactory.newRelocationClassNode(data, offset, length);
        hasBytecode = n.hasBytecode();
        if (digests.containsKey((Object)HashType.NOPKG_BYTECODE)) {
            this.addHash(digests, n.getClassHash(HashType.NOPKG_BYTECODE));
        }
        if (digests.containsKey((Object)HashType.NOPKG_METHOD)) {
            hashes.put(HashType.NOPKG_METHOD, n.getMethodHashes(HashType.NOPKG_METHOD));
        }
        n.stripMethodBodies();
        if (hasBytecode && digests.containsKey((Object)HashType.NOPKG_SIGNATURE)) {
            this.addHash(digests, n.getClassHash(HashType.NOPKG_SIGNATURE));
        }
        if (digests.containsKey((Object)HashType.NOPKG_FIELD)) {
            hashes.put(HashType.NOPKG_FIELD, n.getFieldHashes(HashType.NOPKG_FIELD));
        }
        if (digests.containsKey((Object)HashType.NOPKG_METHOD_SIGNATURE)) {
            hashes.put(HashType.NOPKG_METHOD_SIGNATURE, n.getMethodHashes(HashType.NOPKG_METHOD_SIGNATURE));
        }
        n.stripMembers();
        if (digests.containsKey((Object)HashType.NOPKG_TYPE)) {
            this.addHash(digests, n.getClassHash(HashType.NOPKG_TYPE));
        }
        for (Map.Entry entry : hashes.entrySet()) {
            this.addHash(digests, new MultiHash((HashType)((Object)entry.getKey()), (Collection)entry.getValue()));
        }
    }

    private void addHash(Map<HashType, IMatchable> digests, IMatchable hash) {
        digests.put(hash.getType(), hash);
    }

    static {
        EnumSet<HashType[]> hashTypes = EnumSet.of(HashType.BYTECODE, new HashType[]{HashType.SIGNATURE, HashType.NOPKG_BYTECODE, HashType.NOPKG_SIGNATURE, HashType.TYPE, HashType.FIELD, HashType.METHOD, HashType.METHOD_SIGNATURE, HashType.NOPKG_TYPE, HashType.NOPKG_FIELD, HashType.NOPKG_METHOD, HashType.NOPKG_METHOD_SIGNATURE});
        SUPPORTED_HASH_TYPES = Collections.unmodifiableSet(hashTypes);
    }
}

