/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.ClassFileData;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import zz.org.objectweb.asm.Type;
import zz.org.objectweb.asm.TypePath;
import zz.org.objectweb.asm.v71.ConstantDynamic;
import zz.org.objectweb.asm.v71.Handle;
import zz.org.objectweb.asm.v71.Label;

class ClassFileDigest {
    private final MessageDigest digest = MessageDigest.getInstance("SHA-1");

    ClassFileDigest() throws NoSuchAlgorithmException {
    }

    public byte[] digest() {
        return this.digest.digest();
    }

    void putData(ClassFileData item) {
        if (item != null) {
            item.digest(this);
        }
    }

    void putData(Iterable<? extends ClassFileData> items) {
        for (ClassFileData classFileData : items) {
            classFileData.digest(this);
        }
    }

    void putAccess(int access) {
        this.putInt(access);
    }

    void putString(String string) {
        if (string != null) {
            this.digest.update(string.getBytes(StandardCharsets.UTF_8));
        }
    }

    void putStrings(Iterable<String> strings) {
        for (String string : strings) {
            this.putString(string);
        }
    }

    void putStringsSorted(String[] strings) {
        if (strings != null && strings.length > 0) {
            Arrays.sort(strings);
            for (String string : strings) {
                this.putString(string);
            }
        }
    }

    void putBoolean(Boolean condition) {
        if (condition != null) {
            this.digest.update((byte)(condition != false ? 1 : 0));
        }
    }

    void putByte(int byteValue) {
        this.digest.update((byte)byteValue);
    }

    void putBytes(byte[] bytes) {
        this.digest.update(bytes);
    }

    void putShort(Integer shortValue) {
        if (shortValue != null) {
            this.putShort((int)shortValue);
        }
    }

    void putShort(int shortValue) {
        this.digest.update((byte)(shortValue >>> 8));
        this.digest.update((byte)shortValue);
    }

    void putInt(int intValue) {
        this.digest.update((byte)(intValue >>> 24));
        this.digest.update((byte)(intValue >>> 16));
        this.digest.update((byte)(intValue >>> 8));
        this.digest.update((byte)intValue);
    }

    void putInts(int[] ints) {
        if (ints != null) {
            for (int i : ints) {
                this.putInt(i);
            }
        }
    }

    void putLong(long longValue) {
        int intValue = (int)(longValue >>> 32);
        this.putInt(intValue);
        intValue = (int)longValue;
        this.putInt(intValue);
    }

    void putFloat(float floatValue) {
        this.putInt(Float.floatToRawIntBits(floatValue));
    }

    void putDouble(double doubleValue) {
        this.putLong(Double.doubleToRawLongBits(doubleValue));
    }

    void putObjects(Object ... values) {
        if (values != null) {
            for (Object o : values) {
                this.putObject(o);
            }
        }
    }

    void putObject(Object value) {
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            this.putArray(value);
        } else if (value instanceof String) {
            this.putString((String)value);
        } else if (value instanceof Byte) {
            this.digest.update((Byte)value);
        } else if (value instanceof Short) {
            this.putShort(((Short)value).intValue());
        } else if (value instanceof Integer) {
            this.putInt((Integer)value);
        } else if (value instanceof Long) {
            this.putLong((Long)value);
        } else if (value instanceof Boolean) {
            this.putBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.putShort(((Character)value).charValue());
        } else if (value instanceof Float) {
            this.putFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.putDouble((Double)value);
        } else if (value instanceof Handle) {
            this.putHandle((Handle)value);
        } else if (value instanceof zz.org.objectweb.asm.Handle) {
            this.putHandle((zz.org.objectweb.asm.Handle)value);
        } else if (value instanceof Label) {
            this.putLabel((Label)value);
        } else if (value instanceof zz.org.objectweb.asm.Label) {
            this.putLabel((zz.org.objectweb.asm.Label)value);
        } else if (value instanceof zz.org.objectweb.asm.v71.Type) {
            this.putType((zz.org.objectweb.asm.v71.Type)value);
        } else if (value instanceof Type) {
            this.putType((Type)value);
        } else if (value instanceof zz.org.objectweb.asm.v71.TypePath) {
            this.putTypePath((zz.org.objectweb.asm.v71.TypePath)value);
        } else if (value instanceof TypePath) {
            this.putTypePath((TypePath)value);
        } else if (value instanceof ConstantDynamic) {
            this.putConstantDynamic((ConstantDynamic)value);
        } else if (value instanceof zz.org.objectweb.asm.ConstantDynamic) {
            this.putConstantDynamic((zz.org.objectweb.asm.ConstantDynamic)value);
        } else {
            throw new IllegalArgumentException("value " + value);
        }
    }

    private void putArray(Object value) {
        if (value instanceof byte[]) {
            this.putBytes((byte[])value);
        } else if (value instanceof short[]) {
            for (short i : (short[])value) {
                this.putShort(i);
            }
        } else if (value instanceof int[]) {
            this.putInts((int[])value);
        } else if (value instanceof long[]) {
            for (long l : (long[])value) {
                this.putLong(l);
            }
        } else if (value instanceof boolean[]) {
            for (boolean b : (boolean[])value) {
                this.putBoolean(b);
            }
        } else if (value instanceof char[]) {
            for (char c : (char[])value) {
                this.putShort(c);
            }
        } else if (value instanceof float[]) {
            for (float f : (float[])value) {
                this.putFloat(f);
            }
        } else if (value instanceof double[]) {
            for (double d : (double[])value) {
                this.putDouble(d);
            }
        } else if (value instanceof Object[]) {
            this.putObjects((Object[])value);
        } else {
            throw new IllegalArgumentException("value " + value);
        }
    }

    void putTypePath(zz.org.objectweb.asm.v71.TypePath typePath) {
        if (typePath != null) {
            this.putString(typePath.toString());
        }
    }

    void putTypePath(TypePath typePath) {
        if (typePath != null) {
            this.putString(typePath.toString());
        }
    }

    void putHandle(Handle handle) {
        this.putInt(handle.getTag());
        this.putString(handle.getOwner());
        this.putString(handle.getName());
        this.putString(handle.getDesc());
        this.putBoolean(handle.isInterface());
    }

    void putHandle(zz.org.objectweb.asm.Handle handle) {
        this.putInt(handle.getTag());
        this.putString(handle.getOwner());
        this.putString(handle.getName());
        this.putString(handle.getDesc());
        this.putBoolean(handle.isInterface());
    }

    void putLabel(Label label) {
        if (label != null) {
            this.putInt(label.getOffset());
        }
    }

    void putLabel(zz.org.objectweb.asm.Label label) {
        if (label != null) {
            this.putInt(label.getOffset());
        }
    }

    void putLabels(Label ... labels) {
        if (labels != null) {
            for (Label label : labels) {
                this.putLabel(label);
            }
        }
    }

    void putLabels(zz.org.objectweb.asm.Label ... labels) {
        if (labels != null) {
            for (zz.org.objectweb.asm.Label label : labels) {
                this.putLabel(label);
            }
        }
    }

    private void putType(zz.org.objectweb.asm.v71.Type value) {
        int typeSort = value.getSort();
        if (typeSort == 10) {
            this.putString(value.getInternalName());
        } else if (typeSort == 11) {
            this.putString(value.getDescriptor());
        } else {
            this.putString(value.getDescriptor());
        }
    }

    private void putType(Type value) {
        int typeSort = value.getSort();
        if (typeSort == 10) {
            this.putString(value.getInternalName());
        } else if (typeSort == 11) {
            this.putString(value.getDescriptor());
        } else {
            this.putString(value.getDescriptor());
        }
    }

    private void putConstantDynamic(ConstantDynamic constantDynamic) {
        this.putString(constantDynamic.getName());
        this.putString(constantDynamic.getDescriptor());
        this.putHandle(constantDynamic.getBootstrapMethod());
        for (int i = 0; i < constantDynamic.getBootstrapMethodArgumentCount(); ++i) {
            this.putObject(constantDynamic.getBootstrapMethodArgument(i));
        }
    }

    private void putConstantDynamic(zz.org.objectweb.asm.ConstantDynamic constantDynamic) {
        this.putString(constantDynamic.getName());
        this.putString(constantDynamic.getDescriptor());
        this.putHandle(constantDynamic.getBootstrapMethod());
        for (int i = 0; i < constantDynamic.getBootstrapMethodArgumentCount(); ++i) {
            this.putObject(constantDynamic.getBootstrapMethodArgument(i));
        }
    }
}

