/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.sonatype.insight.scan.manifest.DebianDependency;
import java.util.ArrayList;
import java.util.List;

public class DebianFile {
    private final List<DebianDependency> dependencies = new ArrayList<DebianDependency>();

    private DebianFile(List<String> lines) {
        this.filterDependencies(lines);
    }

    public static DebianFile fromLines(List<String> lines) {
        if (lines == null) {
            return null;
        }
        return new DebianFile(lines);
    }

    private void filterDependencies(List<String> lines) {
        for (String line : lines) {
            DebianDependency dependency = DebianDependency.fromString(line.trim());
            if (dependency == null) continue;
            this.dependencies.add(dependency);
        }
    }

    public List<DebianDependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (DebianDependency dependency : this.dependencies) {
            sb.append(dependency.toString()).append("\n");
        }
        return sb.toString();
    }
}

