/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.tools.manifests.gradle.parser;

import com.sonatype.insight.scan.tools.manifests.gradle.model.BuildModel;
import com.sonatype.insight.scan.tools.manifests.gradle.model.ExternalDependency;
import com.sonatype.insight.scan.tools.manifests.gradle.model.ListVersionConstraint;
import com.sonatype.insight.scan.tools.manifests.gradle.model.LocationAware;
import com.sonatype.insight.scan.tools.manifests.gradle.model.Version;
import com.sonatype.insight.scan.tools.manifests.gradle.model.VersionConstraint;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.BaseCodeVisitor;
import java.util.List;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;

public class DependencyVisitor
extends BaseCodeVisitor {
    private ExternalDependency lastDependency;

    public DependencyVisitor(BuildModel model) {
        super(model);
    }

    @Override
    public void childVisitMethodCallExpression(MethodCallExpression methodCallExpression) {
        this.handleExpandedArtifactSyntax(methodCallExpression);
        this.handleExpandedVersionSyntax(methodCallExpression);
    }

    private void handleExpandedVersionSyntax(MethodCallExpression methodCallExpression) {
        ArgumentListExpression argumentListExpression;
        Expression arguments;
        if (this.lastDependency != null && this.isInVersion() && this.isInDependencies() && (arguments = methodCallExpression.getArguments()) instanceof ArgumentListExpression && (argumentListExpression = (ArgumentListExpression)arguments).getExpressions().size() > 0) {
            for (Expression expression : argumentListExpression) {
                String method;
                if (!(expression instanceof ConstantExpression) && !(expression instanceof GStringExpression)) continue;
                switch (method = methodCallExpression.getMethod().getText()) {
                    case "strictly": {
                        VersionConstraint strictlyConstraint = new VersionConstraint(expression.getText());
                        this.addLocationInfo(strictlyConstraint, methodCallExpression);
                        this.lastDependency.getVersion().setStrictly(strictlyConstraint);
                        break;
                    }
                    case "require": {
                        VersionConstraint requireConstraint = new VersionConstraint(expression.getText());
                        this.addLocationInfo(requireConstraint, methodCallExpression);
                        this.lastDependency.getVersion().setRequire(requireConstraint);
                        break;
                    }
                    case "prefer": {
                        VersionConstraint preferConstraint = new VersionConstraint(expression.getText());
                        this.addLocationInfo(preferConstraint, methodCallExpression);
                        this.lastDependency.getVersion().setPrefer(preferConstraint);
                        break;
                    }
                    case "reject": {
                        if (this.lastDependency.getVersion().getReject() == null) {
                            ListVersionConstraint constraint = new ListVersionConstraint();
                            this.addLocationInfo(constraint, methodCallExpression);
                            this.lastDependency.getVersion().setReject(constraint);
                        }
                        this.lastDependency.getVersion().getReject().addValue(expression.getText());
                        break;
                    }
                }
            }
        }
    }

    private void addLocationInfo(LocationAware constraint, Expression expression) {
        constraint.setLineNumber(expression.getLineNumber()).setColumnNumber(expression.getColumnNumber()).setLastLineNumber(expression.getLastLineNumber()).setLastColumnNumber(expression.getLastColumnNumber());
    }

    private void handleExpandedArtifactSyntax(MethodCallExpression methodCallExpression) {
        Expression expression;
        ArgumentListExpression argumentListExpression;
        Expression arguments;
        if (this.lastDependency != null && this.isInArtifact() && this.isInDependencies() && (arguments = methodCallExpression.getArguments()) instanceof ArgumentListExpression && (argumentListExpression = (ArgumentListExpression)arguments).getExpressions().size() > 0 && ((expression = argumentListExpression.getExpression(0)) instanceof ConstantExpression || expression instanceof GStringExpression)) {
            String method = methodCallExpression.getMethod().getText();
            if ("classifier".equals(method)) {
                this.lastDependency.setClassifier(expression.getText());
            } else if ("extension".equals(method)) {
                this.lastDependency.setExtension(expression.getText());
            }
        }
    }

    @Override
    public void visitArgumentlistExpression(ArgumentListExpression argumentListExpression) {
        if (this.isFileDependency() || this.isProjectDependency() || this.isInExcludeClause()) {
            return;
        }
        if (this.isInDependencies()) {
            List<Expression> expressions = argumentListExpression.getExpressions();
            for (Expression expression : expressions) {
                String[] deps;
                if (!(expression instanceof ConstantExpression) && !(expression instanceof GStringExpression) || (deps = expression.getText().split(":")).length < 2) continue;
                ExternalDependency dependency = new ExternalDependency(this.model).setGroup(deps[0]).setName(deps[1]).setConfigurationName(this.getHeadOfMethodStack()).setCallPath(this.getDependencyCallPath());
                if (deps.length == 2) {
                    dependency.setVersion(new Version());
                } else {
                    dependency.setVersion(new Version(deps[2]));
                }
                dependency.setLineNumber(expression.getLineNumber()).setColumnNumber(expression.getColumnNumber()).setLastLineNumber(expression.getLastLineNumber()).setLastColumnNumber(expression.getLastColumnNumber());
                if (deps.length >= 4) {
                    String[] extras = deps[3].split("@");
                    if (extras.length >= 1) {
                        dependency.setClassifier(extras[0]);
                    }
                    if (extras.length == 2) {
                        dependency.setExtension(extras[1]);
                    }
                }
                this.model.addDependency(dependency);
                this.lastDependency = dependency;
            }
        }
        super.visitArgumentlistExpression(argumentListExpression);
    }

    @Override
    public void visitMapExpression(MapExpression mapExpression) {
        if (this.isInDependencies() && !this.isInExcludeClause()) {
            List<MapEntryExpression> mapEntryExpressions = mapExpression.getMapEntryExpressions();
            ExternalDependency dependency = new ExternalDependency(this.model).setConfigurationName(this.getHeadOfMethodStack()).setCallPath(this.getDependencyCallPath());
            for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
                String key = mapEntryExpression.getKeyExpression().getText();
                Expression valueExpression = mapEntryExpression.getValueExpression();
                String value = valueExpression.getText();
                if (valueExpression instanceof VariableExpression) {
                    value = "$" + value;
                }
                switch (key) {
                    case "group": {
                        dependency.setGroup(value);
                        break;
                    }
                    case "name": {
                        dependency.setName(value);
                        break;
                    }
                    case "version": {
                        dependency.setVersion(new Version(value));
                        break;
                    }
                    case "classifier": {
                        dependency.setClassifier(value);
                        break;
                    }
                    case "ext": {
                        dependency.setExtension(value);
                        break;
                    }
                }
            }
            dependency.setLineNumber(mapExpression.getLineNumber()).setColumnNumber(mapExpression.getColumnNumber()).setLastLineNumber(mapExpression.getLastLineNumber()).setLastColumnNumber(mapExpression.getLastColumnNumber());
            this.model.addDependency(dependency);
            this.lastDependency = dependency;
        }
        super.visitMapExpression(mapExpression);
    }
}

