/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.api;

import com.sonatype.nexus.git.utils.api.GitApi;
import com.sonatype.nexus.git.utils.api.GitException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.apache.commons.io.FileUtils;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.apache.commons.lang3.Validate;
import zz.org.eclipse.jgit.api.CloneCommand;
import zz.org.eclipse.jgit.api.FetchCommand;
import zz.org.eclipse.jgit.api.Git;
import zz.org.eclipse.jgit.api.ListBranchCommand;
import zz.org.eclipse.jgit.api.LsRemoteCommand;
import zz.org.eclipse.jgit.api.PushCommand;
import zz.org.eclipse.jgit.api.ResetCommand;
import zz.org.eclipse.jgit.api.errors.GitAPIException;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.lib.Ref;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.lib.StoredConfig;
import zz.org.eclipse.jgit.revwalk.RevCommit;
import zz.org.eclipse.jgit.revwalk.RevWalk;
import zz.org.eclipse.jgit.revwalk.filter.RevFilter;
import zz.org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import zz.org.eclipse.jgit.transport.CredentialsProvider;
import zz.org.eclipse.jgit.transport.PushResult;
import zz.org.eclipse.jgit.transport.RemoteRefUpdate;
import zz.org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class JGitApi
implements GitApi {
    private static final Logger log = LoggerFactory.getLogger(JGitApi.class);
    private final int timeout;
    private final String repositoryUrl;
    private final CredentialsProvider credentialsProvider;
    static final String OAUTH2_USER = "oauth2";

    public JGitApi(int timeout, String repositoryUrl, String token, String username) {
        this.timeout = timeout;
        this.repositoryUrl = Validate.notEmpty(repositoryUrl, "Repository url is required", new Object[0]);
        Validate.notEmpty(token, "Token is required", new Object[0]);
        if (StringUtils.isNotEmpty(username)) {
            log.debug("Username '{}' was detected, using username/password authentication for {}", (Object)username, (Object)repositoryUrl);
            this.credentialsProvider = new UsernamePasswordCredentialsProvider(username, token);
        } else {
            log.debug("No username was detected, using OAuth token authentication for {}", (Object)repositoryUrl);
            this.credentialsProvider = new UsernamePasswordCredentialsProvider(OAUTH2_USER, token);
        }
        log.debug("Created JGitApi for repository '{}'.", (Object)repositoryUrl);
    }

    public JGitApi(String repositoryUrl, String token, String username) {
        this(300, repositoryUrl, token, username);
    }

    public JGitApi(String repositoryUrl, String token) {
        this(300, repositoryUrl, token, null);
    }

    @Override
    public String cloneOrPullRepository(File target, String branch) throws GitException {
        return this.internalCloneOrPullRepository(target, branch, null);
    }

    @Override
    public String cloneOrPullRepository(File target, String branch, String commitHash) throws GitException {
        this.enforceCommitHash(commitHash, "Invalid commit hash provided");
        return this.internalCloneOrPullRepository(target, branch, commitHash);
    }

    private String internalCloneOrPullRepository(File target, String branch, String commitHash) throws GitException {
        this.validateTarget(target);
        Validate.notEmpty(branch, "Branch is required", new Object[0]);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Repository existingRepository = this.findRepository(target);){
            if (existingRepository != null) {
                return this.cleanResetAndPull(existingRepository, branch, commitHash);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.cloneRepo(target, branch, commitHash);
    }

    /*
     * Loose catch block
     */
    @Override
    public String branch(File target, String branchName) throws GitException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                String string;
                Git git;
                Repository repository;
                block19: {
                    repository = this.findExistingRepository(target);
                    git = Git.open(repository.getDirectory());
                    if (this.branchExists(branchName, git)) {
                        throw new GitException("Branch already exists: " + branchName);
                    }
                    Ref ref = git.checkout().setName(branchName).setCreateBranch(true).call();
                    string = ref.getObjectId().name();
                    if (git != null) {
                        git.close();
                    }
                    if (repository == null) break block19;
                    repository.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (git != null) {
                                git.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (repository != null) {
                                repository.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            throw new GitException("Failed to create branch: " + branchName, e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String commit(File target, String username, String email, String message) throws GitException {
        if (Objects.equals("", email)) {
            email = "<>";
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                String string;
                Git git;
                Repository repository;
                block19: {
                    repository = this.findExistingRepository(target);
                    git = Git.open(repository.getDirectory());
                    RevCommit commit = git.commit().setAll(true).setAllowEmpty(false).setAuthor(username, email).setCommitter(username, email).setSign(false).setMessage(message).call();
                    string = commit.name();
                    if (git != null) {
                        git.close();
                    }
                    if (repository == null) break block19;
                    repository.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (git != null) {
                                git.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (repository != null) {
                                repository.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            throw new GitException("Failed commit", e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String getCommonAncestorCommit(File target, String branchOne, String branchTwo) throws GitException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                String string;
                RevWalk walk;
                Repository repository;
                block18: {
                    repository = this.findExistingRepository(target);
                    walk = new RevWalk(repository);
                    walk.reset();
                    ObjectId objectId1 = repository.resolve("refs/remotes/origin/" + branchOne);
                    RevCommit branchOneHeadCommit = walk.parseCommit(objectId1);
                    ObjectId objectId2 = repository.resolve("refs/remotes/origin/" + branchTwo);
                    RevCommit branchTwoHeadCommit = walk.parseCommit(objectId2);
                    walk.setRevFilter(RevFilter.MERGE_BASE);
                    walk.markStart(branchOneHeadCommit);
                    walk.markStart(branchTwoHeadCommit);
                    RevCommit mergeBase = walk.next();
                    string = mergeBase == null ? null : mergeBase.name();
                    if (walk != null) {
                        walk.close();
                    }
                    if (repository == null) break block18;
                    repository.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (walk != null) {
                                walk.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (repository != null) {
                                repository.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new GitException("Failed to get common ancestor commit because: " + e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String push(File target) throws GitException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                String string;
                Git git;
                Repository repository;
                block20: {
                    repository = this.findExistingRepository(target);
                    git = Git.open(repository.getDirectory());
                    Object push = ((PushCommand)git.push().setCredentialsProvider(this.credentialsProvider)).call();
                    Iterator iterator = push.iterator();
                    while (iterator.hasNext()) {
                        PushResult result = (PushResult)iterator.next();
                        for (RemoteRefUpdate update : result.getRemoteUpdates()) {
                            RemoteRefUpdate.Status status = update.getStatus();
                            if (RemoteRefUpdate.Status.OK.equals((Object)status) || RemoteRefUpdate.Status.UP_TO_DATE.equals((Object)status)) continue;
                            throw new GitException("Failed to push with status: " + (Object)((Object)status));
                        }
                    }
                    string = git.getRepository().findRef("HEAD").getObjectId().name();
                    if (git != null) {
                        git.close();
                    }
                    if (repository == null) break block20;
                    repository.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (git != null) {
                                git.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (repository != null) {
                                repository.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            throw new GitException("Failed push", e);
        }
    }

    @Override
    public Map<String, String> getHeadCommitsForAllBranches(String repositoryUrl) throws GitException {
        try {
            Map<String, Ref> refMap = ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(repositoryUrl).setCredentialsProvider(this.credentialsProvider)).setHeads(true).callAsMap();
            HashMap<String, String> result = new HashMap<String, String>();
            refMap.forEach((k, v) -> {
                String string = result.put(k.substring(11), v.getObjectId().getName());
            });
            return result;
        }
        catch (GitAPIException e) {
            throw new GitException("Failed to get head commits for all branches", e);
        }
    }

    private String cloneRepo(File target, String branch, String commitHash) throws GitException {
        if (!this.isDirEmpty(target.toPath())) {
            throw new IllegalStateException("Target directory for new clone is not empty: " + target.getAbsolutePath());
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Git git = ((CloneCommand)((CloneCommand)Git.cloneRepository().setURI(this.repositoryUrl).setCredentialsProvider(this.credentialsProvider)).setBranch(branch).setCloneAllBranches(true).setDirectory(target).setTimeout(this.timeout)).call();){
                if (!this.branchExists(branch, git)) {
                    throw new GitException("Branch '" + branch + "' does not exist");
                }
                if (commitHash != null) {
                    this.checkoutCommit(target, commitHash);
                    return commitHash;
                }
                return this.getHeadRef(git);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            String message = "Unable to clone from repoUrl '" + this.repositoryUrl + "' with branch '" + branch + "'";
            if (commitHash != null) {
                message = String.valueOf(message) + " and commit '" + commitHash + "'";
            }
            throw new GitException(message, e);
        }
    }

    private void checkoutCommit(File target, String commitHash) throws IOException, GitAPIException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Git git = Git.open(target);){
            git.checkout().setName(commitHash).call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String cleanResetAndPull(Repository repository, String branch, String commitHash) throws GitException {
        this.validateRepository(repository);
        try {
            this.ensureAllBranchesAreFetched(repository);
        }
        catch (IOException e) {
            throw new GitException("Failed check/update git config in directory: " + repository.getDirectory(), e);
        }
        try {
            Throwable e = null;
            Object var5_8 = null;
            try (Git git = Git.open(repository.getDirectory());){
                git.clean().setCleanDirectories(true).call();
                ((FetchCommand)git.fetch().setCredentialsProvider(this.credentialsProvider)).call();
                if (commitHash == null) {
                    git.checkout().setCreateBranch(!this.localBranchExists(branch, git)).setName(branch).call();
                    git.reset().setMode(ResetCommand.ResetType.HARD).setRef("origin/" + branch).call();
                } else {
                    git.checkout().setName(commitHash).call();
                    git.reset().setMode(ResetCommand.ResetType.HARD).setRef(commitHash).call();
                }
                String string = commitHash == null ? git.getRepository().findRef("HEAD").getObjectId().name() : commitHash;
                return string;
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException | GitAPIException e) {
            throw new GitException("Failed to reset and pull in directory: " + repository.getDirectory(), e);
        }
    }

    private boolean localBranchExists(String branchName, Git git) throws GitAPIException {
        return git.branchList().call().stream().map(Ref::getName).collect(Collectors.toList()).contains("refs/heads/" + branchName);
    }

    private void ensureAllBranchesAreFetched(Repository repository) throws IOException {
        String expectedRefSpecs = "+refs/heads/*:refs/remotes/origin/*";
        StoredConfig config = repository.getConfig();
        String configString = config.getString("remote", "origin", "fetch");
        if (!expectedRefSpecs.equals(configString)) {
            config.setString("remote", "origin", "fetch", expectedRefSpecs);
            config.save();
        }
    }

    private void validateRepository(Repository repository) throws GitException {
        String remoteUrl = repository.getConfig().getString("remote", "origin", "url");
        if (remoteUrl == null) {
            throw new GitException("The repository does not have a remote url configured");
        }
        if (!remoteUrl.equals(this.repositoryUrl)) {
            throw new GitException("This repository is configured for a different remote url: " + remoteUrl + " than the one specified: " + this.repositoryUrl);
        }
    }

    private Repository findExistingRepository(File target) {
        Repository repository = this.findRepository(target);
        if (this.findRepository(target) == null) {
            throw new IllegalStateException("No repository present in target directory: " + target.getAbsolutePath());
        }
        return repository;
    }

    Repository findRepository(File target) {
        File dotGitDir = new File(target, ".git");
        if (!dotGitDir.isDirectory()) {
            return null;
        }
        try {
            return ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(dotGitDir)).setMustExist(true)).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.cleanDirectory(target);
            return null;
        }
    }

    private void cleanDirectory(File dir) {
        try {
            FileUtils.cleanDirectory(dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getHeadRef(Git git) throws IOException {
        return git.getRepository().findRef("HEAD").getObjectId().name();
    }

    private boolean branchExists(String branchName, Git git) throws GitAPIException {
        return git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().stream().anyMatch(ref -> {
            String name = ref.getName().replaceAll("refs/heads/", "");
            return name.equals(branchName);
        });
    }

    @Override
    public boolean isDirEmpty(Path directory) {
        try {
            return GitApi.super.isDirEmpty(directory);
        }
        catch (IOException e) {
            log.error("Failed to test if directory was empty: {}", (Object)directory, (Object)e);
            return false;
        }
    }
}

