/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.commit;

import com.sonatype.nexus.git.utils.commit.CommitHashFinder;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateCommitHashFinder
implements CommitHashFinder {
    final CommitHashFinder[] strategies;
    final String fallback;
    final Logger log;

    AggregateCommitHashFinder(CommitHashFinder ... strategies) {
        this((String)null, (Logger)null, strategies);
    }

    AggregateCommitHashFinder(String fallback, CommitHashFinder ... strategies) {
        this(fallback, (Logger)null, strategies);
    }

    AggregateCommitHashFinder(String fallback, Logger log, CommitHashFinder ... strategies) {
        this.strategies = strategies;
        this.fallback = fallback;
        this.log = log == null ? LoggerFactory.getLogger(AggregateCommitHashFinder.class) : log;
    }

    @Override
    public Optional<String> tryGetCommitHash() {
        CommitHashFinder[] commitHashFinderArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            CommitHashFinder strategy = commitHashFinderArray[n2];
            Optional<String> hash = strategy.tryGetCommitHash();
            if (hash.isPresent()) {
                this.log.info("Discovered commit hash '{}' via {}", (Object)hash.get(), (Object)strategy.getDescription());
                return hash;
            }
            this.log.debug("Unable to find commit hash via {}", (Object)strategy.getDescription());
            ++n2;
        }
        this.log.info("Could not discover git commit hash via automation");
        return Optional.ofNullable(this.fallback);
    }

    @Override
    public String getDescription() {
        return "aggregate";
    }
}

