/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.repository;

import com.sonatype.nexus.git.utils.common.BaseJGitFinder;
import com.sonatype.nexus.git.utils.repository.RepositoryUrlFinder;
import com.sonatype.nexus.git.utils.repository.RepositoryUrlFinderUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.eclipse.jgit.lib.Repository;

public class JGitRepositoryUrlFinder
extends BaseJGitFinder
implements RepositoryUrlFinder {
    private static final Logger log = LoggerFactory.getLogger(JGitRepositoryUrlFinder.class);
    private final String repositoryPath;

    JGitRepositoryUrlFinder() {
        this(null);
    }

    JGitRepositoryUrlFinder(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    @Override
    public Optional<String> tryGetRepositoryUrl() {
        try {
            Repository repository = this.getJGitRepository(this.repositoryPath);
            String remoteUrl = repository.getConfig().getString("remote", "origin", "url");
            if (StringUtils.isBlank(remoteUrl)) {
                log.warn("Unable to ascertain remote url from repository at: {}", (Object)repository.getDirectory());
                return Optional.empty();
            }
            return Optional.of(RepositoryUrlFinderUtils.sanitizeUrl(remoteUrl));
        }
        catch (Exception e) {
            log.debug("Failed to get the repository URL due to:", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public String getDescription() {
        return "jGit";
    }
}

