/*
 * Decompiled with CFR 0.152.
 */
package zz.com.ethlo.time;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import zz.com.ethlo.time.DateTime;
import zz.com.ethlo.time.Field;
import zz.com.ethlo.time.TemporalConsumer;
import zz.com.ethlo.time.TemporalHandler;
import zz.com.ethlo.time.TemporalType;
import zz.com.ethlo.time.internal.EthloITU;

public class ITU {
    private static final EthloITU delegate = EthloITU.getInstance();

    private ITU() {
    }

    public static OffsetDateTime parseDateTime(String text) {
        return delegate.parseDateTime(text);
    }

    public static DateTime parseLenient(String text) {
        return delegate.parse(text);
    }

    public static boolean isValid(String text) {
        try {
            ITU.parseDateTime(text);
            return true;
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    public static String formatUtc(OffsetDateTime offsetDateTime, int fractionDigits) {
        return delegate.formatUtc(offsetDateTime, fractionDigits);
    }

    public static String formatUtc(OffsetDateTime offsetDateTime, Field lastIncluded) {
        return delegate.formatUtc(offsetDateTime, lastIncluded);
    }

    public static String format(OffsetDateTime offsetDateTime) {
        return delegate.format(offsetDateTime, offsetDateTime.getOffset(), 0);
    }

    public static String format(OffsetDateTime offsetDateTime, int fractionDigits) {
        return delegate.format(offsetDateTime, offsetDateTime.getOffset(), fractionDigits);
    }

    public static String formatUtc(OffsetDateTime offsetDateTime) {
        return delegate.formatUtc(offsetDateTime);
    }

    public static String formatUtcMilli(OffsetDateTime offsetDateTime) {
        return delegate.formatUtcMilli(offsetDateTime);
    }

    public static String formatUtcMicro(OffsetDateTime offsetDateTime) {
        return delegate.formatUtcMicro(offsetDateTime);
    }

    public static String formatUtcNano(OffsetDateTime offsetDateTime) {
        return delegate.formatUtcNano(offsetDateTime);
    }

    public static void parse(String text, TemporalConsumer temporalConsumer) {
        DateTime dateTime = delegate.parse(text);
        if (dateTime.includesGranularity(Field.MINUTE)) {
            if (dateTime.getOffset().isPresent()) {
                temporalConsumer.handle(dateTime.toOffsetDatetime());
            } else {
                temporalConsumer.handle(dateTime.toLocalDatetime());
            }
        } else if (dateTime.includesGranularity(Field.DAY)) {
            temporalConsumer.handle(dateTime.toLocalDate());
        } else if (dateTime.includesGranularity(Field.MONTH)) {
            temporalConsumer.handle(dateTime.toYearMonth());
        } else {
            temporalConsumer.handle(Year.of(dateTime.getYear()));
        }
    }

    public static <T> T parse(String text, TemporalHandler<T> temporalHandler) {
        DateTime dateTime = delegate.parse(text);
        if (dateTime.includesGranularity(Field.MINUTE)) {
            if (dateTime.getOffset().isPresent()) {
                return temporalHandler.handle(dateTime.toOffsetDatetime());
            }
            return temporalHandler.handle(dateTime.toLocalDatetime());
        }
        if (dateTime.includesGranularity(Field.DAY)) {
            return temporalHandler.handle(dateTime.toLocalDate());
        }
        if (dateTime.includesGranularity(Field.MONTH)) {
            return temporalHandler.handle(dateTime.toYearMonth());
        }
        return temporalHandler.handle(Year.of(dateTime.getYear()));
    }

    public static boolean isValid(String text, final TemporalType ... types) {
        try {
            return ITU.parse(text, new TemporalHandler<Boolean>(){

                @Override
                public Boolean handle(LocalDate localDate) {
                    return ITU.isAllowed(TemporalType.LOCAL_DATE, types);
                }

                @Override
                public Boolean handle(OffsetDateTime offsetDateTime) {
                    return ITU.isAllowed(TemporalType.OFFSET_DATE_TIME, types);
                }

                @Override
                public Boolean handle(LocalDateTime localDateTime) {
                    return ITU.isAllowed(TemporalType.LOCAL_DATE_TIME, types);
                }

                @Override
                public Boolean handle(YearMonth yearMonth) {
                    return ITU.isAllowed(TemporalType.YEAR_MONTH, types);
                }

                @Override
                public Boolean handle(Year year) {
                    return ITU.isAllowed(TemporalType.YEAR, types);
                }
            });
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    private static boolean isAllowed(TemporalType needle, TemporalType ... allowed) {
        for (TemporalType t : allowed) {
            if (!t.equals((Object)needle)) continue;
            return true;
        }
        return false;
    }
}

