/*
 * Decompiled with CFR 0.152.
 */
package zz.com.ethlo.time.internal;

import java.time.DateTimeException;
import java.util.Arrays;

public final class LimitedCharArrayIntegerUtil {
    public static final char DIGIT_9 = '9';
    private static final char ZERO = '0';
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final int TABLE_WIDTH = 4;
    private static final int RADIX = 10;
    private static final int MAX_INT_WIDTH = 10;
    private static final int TABLE_SIZE = (int)Math.pow(10.0, 4.0);
    private static final char[] INT_CONVERSION_CACHE = new char[TABLE_SIZE * 4 + 10];

    private LimitedCharArrayIntegerUtil() {
    }

    public static int parsePositiveInt(char[] strNum, int startInclusive, int endExclusive) {
        if (endExclusive > strNum.length) {
            throw new DateTimeException("Unexpected end of expression at position " + strNum.length + ": '" + new String(strNum) + "'");
        }
        int result = 0;
        for (int i = startInclusive; i < endExclusive; ++i) {
            char c = strNum[i];
            if (LimitedCharArrayIntegerUtil.isNotDigit(c)) {
                throw new DateTimeException("Character " + c + " is not a digit");
            }
            int digit = LimitedCharArrayIntegerUtil.digit(c);
            result *= 10;
            result -= digit;
        }
        return -result;
    }

    public static int uncheckedParsePositiveInt(char[] strNum, int startInclusive, int endExclusive) {
        int result = 0;
        for (int i = startInclusive; i < endExclusive; ++i) {
            char c = strNum[i];
            int digit = LimitedCharArrayIntegerUtil.digit(c);
            result *= 10;
            result -= digit;
        }
        return -result;
    }

    public static void toString(int value, char[] buf, int offset, int charLength) {
        if (value < TABLE_SIZE) {
            int length = Math.min(4, charLength);
            int padPrefixLen = charLength - length;
            int start = charLength > 4 ? 4 : 4 - charLength;
            int targetOffset = offset + padPrefixLen;
            int srcPos = value * 4 + (charLength < 4 ? start : 0);
            LimitedCharArrayIntegerUtil.copy(INT_CONVERSION_CACHE, srcPos, buf, targetOffset, length);
            if (padPrefixLen > 0) {
                LimitedCharArrayIntegerUtil.zeroFill(buf, offset, padPrefixLen);
            }
        } else {
            LimitedCharArrayIntegerUtil.createBufferEntry(buf, offset, charLength, value);
        }
    }

    private static void createBufferEntry(char[] buf, int offset, int charLength, int value) {
        int charPos = offset + 10;
        value = -value;
        while (value <= -10) {
            int div = value / 10;
            int rem = -(value - 10 * div);
            buf[charPos--] = DIGITS[rem];
            value = div;
        }
        buf[charPos] = DIGITS[-value];
        for (int l = 10 + offset - charPos + 1; l < charLength; ++l) {
            buf[--charPos] = 48;
        }
        int srcPos = charPos;
        LimitedCharArrayIntegerUtil.copy(buf, srcPos, offset, charLength);
    }

    private static void zeroFill(char[] buf, int offset, int padPrefixLen) {
        Arrays.fill(buf, offset, offset + padPrefixLen, '0');
    }

    private static void copy(char[] buf, int srcPos, int offset, int length) {
        LimitedCharArrayIntegerUtil.copy(buf, srcPos, buf, offset, length);
    }

    private static void copy(char[] buf, int srcPos, char[] target, int offset, int length) {
        System.arraycopy(buf, srcPos, target, offset, length);
    }

    public static int indexOfNonDigit(char[] text, int offset) {
        for (int i = offset; i < text.length; ++i) {
            if (!LimitedCharArrayIntegerUtil.isNotDigit(text[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNotDigit(char c) {
        return c < '0' || c > '9';
    }

    private static int digit(char c) {
        return c - 48;
    }

    static {
        int offset = 0;
        for (int i = 0; i < TABLE_SIZE; ++i) {
            LimitedCharArrayIntegerUtil.createBufferEntry(INT_CONVERSION_CACHE, offset, 4, i);
            offset += 4;
        }
    }
}

