/*
 * Decompiled with CFR 0.152.
 */
package zz.com.googlecode.javaewah;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import zz.com.googlecode.javaewah.BufferedXORIterator;
import zz.com.googlecode.javaewah.CloneableIterator;
import zz.com.googlecode.javaewah.EWAHCompressedBitmap;
import zz.com.googlecode.javaewah.EWAHIterator;
import zz.com.googlecode.javaewah.IteratingRLW;
import zz.com.googlecode.javaewah.IteratorAggregation;

class BufferedORIterator
implements CloneableIterator<EWAHIterator> {
    final EWAHCompressedBitmap buffer = new EWAHCompressedBitmap();
    final long[] hardBitmap;
    final LinkedList<IteratingRLW> ll;

    BufferedORIterator(LinkedList<IteratingRLW> basell, int bufSize) {
        this.ll = basell;
        this.hardBitmap = new long[bufSize];
    }

    public BufferedXORIterator clone() throws CloneNotSupportedException {
        BufferedXORIterator answer = (BufferedXORIterator)super.clone();
        answer.buffer = this.buffer.clone();
        answer.hardbitmap = (long[])this.hardBitmap.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator next() {
        this.buffer.clear();
        long effective = 0L;
        Iterator i = this.ll.iterator();
        while (i.hasNext()) {
            IteratingRLW rlw = (IteratingRLW)i.next();
            if (rlw.size() > 0L) {
                int eff = IteratorAggregation.inplaceor(this.hardBitmap, rlw);
                if ((long)eff <= effective) continue;
                effective = eff;
                continue;
            }
            i.remove();
        }
        int k = 0;
        while ((long)k < effective) {
            this.buffer.addWord(this.hardBitmap[k]);
            ++k;
        }
        Arrays.fill(this.hardBitmap, 0L);
        return this.buffer.getEWAHIterator();
    }
}

