/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.DateTimeValidator;
import zz.com.networknt.schema.Format;
import zz.com.networknt.schema.FormatValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.Keyword;
import zz.com.networknt.schema.UUIDValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidatorTypeCode;
import zz.com.networknt.schema.format.DurationValidator;
import zz.com.networknt.schema.format.EmailValidator;

public class FormatKeyword
implements Keyword {
    private static final String DATE = "date";
    private static final String DATE_TIME = "date-time";
    private static final String UUID = "uuid";
    private static final String EMAIL = "email";
    private static final String DURATION = "duration";
    private final ValidatorTypeCode type;
    private final Map<String, Format> formats;

    public FormatKeyword(ValidatorTypeCode type, Map<String, Format> formats) {
        this.type = type;
        this.formats = formats;
    }

    Collection<Format> getFormats() {
        return Collections.unmodifiableCollection(this.formats.values());
    }

    @Override
    public JsonValidator newValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) throws Exception {
        Format format = null;
        if (schemaNode != null && schemaNode.isTextual()) {
            String formatName = schemaNode.textValue();
            format = this.formats.get(formatName);
            if (format != null) {
                return new FormatValidator(schemaPath, schemaNode, parentSchema, validationContext, format, this.type);
            }
            if (formatName.equals(DATE) || formatName.equals(DATE_TIME)) {
                ValidatorTypeCode typeCode = ValidatorTypeCode.DATETIME;
                typeCode.setCustomMessage(this.type.getCustomMessage());
                return new DateTimeValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName, typeCode);
            }
            if (formatName.equals(UUID)) {
                ValidatorTypeCode typeCode = ValidatorTypeCode.UUID;
                typeCode.setCustomMessage(this.type.getCustomMessage());
                return new UUIDValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName, typeCode);
            }
            if (formatName.equals(EMAIL)) {
                return new EmailValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName, this.type);
            }
            if (formatName.equals(DURATION)) {
                return new DurationValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName, this.type);
            }
        }
        return new FormatValidator(schemaPath, schemaNode, parentSchema, validationContext, format, this.type);
    }

    @Override
    public String getValue() {
        return this.type.getValue();
    }

    @Override
    public void setCustomMessage(String message) {
        this.type.setCustomMessage(message);
    }
}

