/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class MultipleOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MultipleOfValidator.class);
    private double divisor = 0.0;

    public MultipleOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MULTIPLE_OF, validationContext);
        if (schemaNode.isNumber()) {
            this.divisor = schemaNode.doubleValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (node.isNumber()) {
            BigDecimal accurateDivisor;
            BigDecimal accurateDividend;
            double nodeValue = node.doubleValue();
            if (this.divisor != 0.0 && (accurateDividend = node.isBigDecimal() ? node.decimalValue() : new BigDecimal(String.valueOf(nodeValue))).divideAndRemainder(accurateDivisor = new BigDecimal(String.valueOf(this.divisor)))[1].abs().compareTo(BigDecimal.ZERO) > 0) {
                return Collections.singleton(this.buildValidationMessage(at, "" + this.divisor));
            }
        }
        return Collections.emptySet();
    }
}

