/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.CollectorContext;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class UnEvaluatedPropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnEvaluatedPropertiesValidator.class);
    public static final String EVALUATED_PROPERTIES = "zz.com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties";
    public static final String UNEVALUATED_PROPERTIES = "zz.com.networknt.schema.UnEvaluatedPropertiesValidator.UnevaluatedProperties";
    private JsonNode schemaNode = null;

    public UnEvaluatedPropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_PROPERTIES, validationContext);
        this.schemaNode = schemaNode;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        if (!this.schemaNode.isBoolean()) {
            return Collections.emptySet();
        }
        boolean unevaluatedProperties = this.schemaNode.booleanValue();
        ArrayList<String> allPaths = new ArrayList<String>();
        this.processAllPaths(node, at, allPaths);
        if (!unevaluatedProperties) {
            List<String> unEvaluatedProperties = this.getUnEvaluatedProperties(allPaths);
            if (!unEvaluatedProperties.isEmpty()) {
                CollectorContext.getInstance().add(UNEVALUATED_PROPERTIES, unEvaluatedProperties);
                return Collections.singleton(this.buildValidationMessage(String.join((CharSequence)", ", unEvaluatedProperties), new String[0]));
            }
        } else {
            CollectorContext.getInstance().add(EVALUATED_PROPERTIES, allPaths);
        }
        return Collections.emptySet();
    }

    private List<String> getUnEvaluatedProperties(List<String> allPaths) {
        ArrayList<String> unevaluatedPropertiesList = new ArrayList<String>();
        Object evaluatedPropertiesObj = CollectorContext.getInstance().get(EVALUATED_PROPERTIES);
        if (evaluatedPropertiesObj != null) {
            List evaluatedPropertiesList = (List)evaluatedPropertiesObj;
            allPaths.forEach(path -> {
                if (!evaluatedPropertiesList.contains(path)) {
                    unevaluatedPropertiesList.add((String)path);
                }
            });
        } else {
            unevaluatedPropertiesList.addAll(allPaths);
        }
        return unevaluatedPropertiesList;
    }

    public void processAllPaths(JsonNode node, String at, List<String> paths) {
        Iterator<String> nodesIterator = node.fieldNames();
        while (nodesIterator.hasNext()) {
            String fieldName = nodesIterator.next();
            JsonNode jsonNode = node.get(fieldName);
            if (jsonNode.isObject()) {
                this.processAllPaths(jsonNode, at + "." + fieldName, paths);
            }
            paths.add(at + "." + fieldName);
        }
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        return Collections.emptySet();
    }
}

