/*
 * Decompiled with CFR 0.152.
 */
package zz.com.neuvector;

import java.util.ArrayList;
import java.util.List;

public class DockerRunCommandBuilder {
    private final List<String> cmdList = new ArrayList<String>();

    public DockerRunCommandBuilder() {
        this.cmdList.add("docker");
        this.cmdList.add("run");
        this.cmdList.add("--rm");
    }

    DockerRunCommandBuilder withUserAndGroup(String userIdGroupId) {
        if (userIdGroupId != null && userIdGroupId.length() > 0) {
            this.cmdList.add("-u");
            this.cmdList.add(userIdGroupId);
        }
        return this;
    }

    DockerRunCommandBuilder withName(String name) {
        this.cmdList.add("--name");
        this.cmdList.add(name);
        return this;
    }

    DockerRunCommandBuilder withVolume(String volumeMapping) {
        this.cmdList.add("-v");
        this.cmdList.add(volumeMapping);
        return this;
    }

    DockerRunCommandBuilder withEnvironment(String environmentVariable) {
        this.cmdList.add("-e");
        this.cmdList.add(environmentVariable);
        return this;
    }

    String[] buildForImage(String image) {
        this.cmdList.add(image);
        return this.cmdList.toArray(new String[0]);
    }
}

