/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;
import zz.com.thoughtworks.xstream.security.AnyTypePermission;
import zz.com.thoughtworks.xstream.security.ForbiddenClassException;
import zz.com.thoughtworks.xstream.security.NoTypePermission;
import zz.com.thoughtworks.xstream.security.TypePermission;

public class SecurityMapper
extends MapperWrapper {
    private final List permissions;

    public SecurityMapper(Mapper wrapped) {
        this(wrapped, null);
    }

    public SecurityMapper(Mapper wrapped, TypePermission[] permissions) {
        super(wrapped);
        this.permissions = permissions == null ? new ArrayList() : new ArrayList<TypePermission>(Arrays.asList(permissions));
    }

    public void addPermission(TypePermission permission) {
        if (permission.equals(NoTypePermission.NONE) || permission.equals(AnyTypePermission.ANY)) {
            this.permissions.clear();
        }
        this.permissions.add(0, permission);
    }

    public Class realClass(String elementName) {
        Class type = super.realClass(elementName);
        for (int i = 0; i < this.permissions.size(); ++i) {
            TypePermission permission = (TypePermission)this.permissions.get(i);
            if (!permission.allows(type)) continue;
            return type;
        }
        throw new ForbiddenClassException(type);
    }
}

